/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.zk.console;

import java.util.List;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.zookeeper.ZooKeeper;
import org.eclipse.gyrex.cloud.internal.zk.console.RecursivePathBasedCmd;

public class ListCmd
extends RecursivePathBasedCmd {
    public ListCmd() {
        super("- lists the specified path");
    }

    @Override
    protected void doExecute(ZooKeeper zk, String path) throws Exception {
        if (this.recursive) {
            this.printTree(path, 0, zk);
        } else {
            List children = zk.getChildren(path, false);
            for (String child : children) {
                this.ci.println((Object)child);
            }
        }
    }

    private void printTree(String path, int indent, ZooKeeper zk) throws Exception {
        List children = zk.getChildren(path, false);
        StrBuilder spaces = new StrBuilder();
        int i = 0;
        while (i < indent) {
            spaces.append(" ");
            ++i;
        }
        this.ci.println((Object)spaces.append(path).append(" (").append(children.size()).append(")"));
        for (String child : children) {
            this.printTree(String.valueOf(path) + (path.equals("/") ? "" : "/") + child, indent + 1, zk);
        }
    }
}

