/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jaxrs;

import com.sun.jersey.api.container.filter.LoggingFilter;
import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.sun.jersey.spi.inject.Errors;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Handler;
import javax.servlet.Servlet;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.http.application.Application;
import org.eclipse.gyrex.http.jaxrs.internal.JaxRsDebug;
import org.eclipse.gyrex.http.jaxrs.internal.JaxRsExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxRsApplication
extends Application {
    private static final Logger LOG = LoggerFactory.getLogger(JaxRsApplication.class);

    protected JaxRsApplication(String id, IRuntimeContext context) {
        super(id, context);
    }

    protected javax.ws.rs.core.Application createJaxRsApplication() {
        Set<Object> singletons;
        DefaultResourceConfig resourceConfig = new DefaultResourceConfig();
        Set<Class<?>> classes = this.getJaxRsClasses();
        if (classes != null) {
            resourceConfig.getClasses().addAll(classes);
        }
        if ((singletons = this.getJaxRsSingletons()) != null) {
            resourceConfig.getSingletons().addAll(singletons);
        }
        JaxRsExtensions.addCommonInjectors(resourceConfig.getSingletons(), this.getContext(), this.getApplicationContext());
        JaxRsExtensions.addJsonProviderIfPossible(resourceConfig.getSingletons());
        JaxRsExtensions.addWadlSupport((ResourceConfig)resourceConfig);
        resourceConfig.getProperties().putAll(this.getApplicationContext().getInitProperties());
        if (!resourceConfig.getProperties().containsKey("com.sun.jersey.spi.container.ContainerRequestFilters")) {
            resourceConfig.getProperties().put("com.sun.jersey.spi.container.ContainerRequestFilters", LoggingFilter.class.getName());
        }
        if (!resourceConfig.getProperties().containsKey("com.sun.jersey.spi.container.ContainerResponseFilters")) {
            resourceConfig.getProperties().put("com.sun.jersey.spi.container.ContainerResponseFilters", LoggingFilter.class.getName());
        }
        return resourceConfig;
    }

    /*
     * Unable to fully structure code
     */
    protected void doInit() throws IllegalStateException, Exception {
        block4: {
            jaxRsApplication = this.createJaxRsApplication();
            if (jaxRsApplication == null) {
                throw new IllegalStateException("no application returned by createJaxRsApplication");
            }
            this.installSlf4jBridgeIfNecessary();
            try {
                this.getApplicationContext().registerServlet(this.getJaxRsAlias(), (Servlet)new ServletContainer(jaxRsApplication), null);
                break block4;
            }
            catch (Errors.ErrorMessagesException e) {
                error = new StrBuilder("Error initializing JAX-RS application.");
                ** for (m : e.messages)
            }
lbl-1000:
            // 1 sources

            {
                error.appendNewLine().append("> ").append(this.extractMessage(m));
                continue;
            }
lbl14:
            // 1 sources

            throw new IllegalStateException(error.toString(), e);
        }
    }

    private String extractMessage(Errors.ErrorMessage m) {
        try {
            Field f = m.getClass().getDeclaredField("message");
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            return (String)f.get(m);
        }
        catch (Exception e) {
            return String.format("%s (%s)", m, ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    protected String getJaxRsAlias() {
        return "/";
    }

    protected Set<Class<?>> getJaxRsClasses() {
        return Collections.emptySet();
    }

    protected Set<Object> getJaxRsSingletons() {
        return Collections.emptySet();
    }

    private void installSlf4jBridgeIfNecessary() {
        block7: {
            if (JaxRsDebug.debug) {
                LOG.debug("Installing SLF4J JUL bridge handler to enable Jersey logging.");
            }
            try {
                Class<?> bridgeHandlerClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.slf4j.bridge.SLF4JBridgeHandler");
                if (!Boolean.TRUE.equals(bridgeHandlerClass.getMethod("isInstalled", new Class[0]).invoke(null, new Object[0]))) {
                    Handler[] handlers;
                    java.util.logging.Logger jerseyLogger = java.util.logging.Logger.getLogger("com.sun.jersey");
                    Handler[] handlerArray = handlers = jerseyLogger.getHandlers();
                    int n = handlers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Handler handler = handlerArray[n2];
                        if (bridgeHandlerClass.getName().equals(handler.getClass().getName())) {
                            if (JaxRsDebug.debug) {
                                LOG.debug("SLF4J JUL bridge handler already installed.");
                            }
                            return;
                        }
                        ++n2;
                    }
                    jerseyLogger.addHandler((Handler)bridgeHandlerClass.newInstance());
                }
            }
            catch (Exception e) {
                if (!JaxRsDebug.debug) break block7;
                LOG.debug("Unable to install SLF4J JUL bridge.", (Throwable)e);
            }
        }
    }
}

