/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jaxrs.internal;

import com.sun.jersey.core.header.MediaTypes;
import com.sun.jersey.server.wadl.ApplicationDescription;
import com.sun.jersey.server.wadl.WadlApplicationContext;
import com.sun.jersey.spi.resource.Singleton;
import com.sun.research.ws.wadl.Application;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/application.wadl")
public class WadlResource {
    private static final Logger LOG = LoggerFactory.getLogger(WadlResource.class);
    private final Map<String, WadlRepresentation> wadlRepresentationByBaseUri = new HashMap<String, WadlRepresentation>();
    private final WadlApplicationContext wadlContext;
    private String xslStylesheetLocation;

    public WadlResource(@Context WadlApplicationContext wadlContext) {
        this.wadlContext = wadlContext;
    }

    @Produces(value={"*/*"})
    @GET
    @Path(value="{path}")
    public synchronized Response geExternalGramar(@Context UriInfo uriInfo, @PathParam(value="path") String path) {
        if (!this.wadlContext.isWadlGenerationEnabled()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ApplicationDescription.ExternalGrammar externalMetadata = this.wadlContext.getApplication(uriInfo).getExternalGrammar(path);
        if (externalMetadata == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok().type(externalMetadata.getType()).entity((Object)externalMetadata.getContent()).build();
    }

    protected String getStylesheetLocation(UriInfo uriInfo) {
        String location = this.getXslStylesheetLocation();
        if (location != null) {
            return location;
        }
        return "https://raw.github.com/ipcsystems/wadl-stylesheet/master/wadl.xsl";
    }

    @GET
    @Produces(value={"application/vnd.sun.wadl+xml", "application/vnd.sun.wadl+json", "application/xml"})
    public synchronized Response getWadl(@Context Request request, @Context UriInfo uriInfo, @Context Providers providers) {
        Throwable builder2;
        WadlRepresentation wadlRepresentation;
        CacheControl cc;
        EntityTag eTag;
        String cacheKey;
        block28: {
            if (!this.wadlContext.isWadlGenerationEnabled()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            List vl = Variant.mediaTypes((MediaType[])new MediaType[]{MediaTypes.WADL, MediaTypes.WADL_JSON, MediaType.APPLICATION_XML_TYPE}).add().build();
            Variant v = request.selectVariant(vl);
            if (v == null) {
                return Response.notAcceptable((List)vl).build();
            }
            cacheKey = DigestUtils.md5Hex((String)(String.valueOf(uriInfo.getBaseUri().toASCIIString()) + "--" + v.toString()));
            eTag = new EntityTag(cacheKey);
            cc = new CacheControl();
            cc.setMaxAge(86400);
            cc.setPrivate(true);
            wadlRepresentation = this.wadlRepresentationByBaseUri.get(cacheKey);
            if (wadlRepresentation != null) {
                Response.ResponseBuilder builder2 = request.evaluatePreconditions(wadlRepresentation.lastModified, eTag);
                if (builder2 == null) {
                    builder2 = Response.ok((Object)new ByteArrayInputStream(wadlRepresentation.wadlXml));
                    builder2.tag(eTag);
                    builder2.lastModified(wadlRepresentation.lastModified);
                }
                builder2.cacheControl(cc);
                return builder2.build();
            }
            try {
                builder2 = null;
                Object var11_14 = null;
                try {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    ApplicationDescription applicationDescription = this.wadlContext.getApplication(uriInfo);
                    Application application = applicationDescription.getApplication();
                    if (v.getMediaType().equals((Object)MediaTypes.WADL) || v.getMediaType().equals((Object)MediaType.APPLICATION_XML_TYPE)) {
                        try {
                            JAXBContext jaxbContext = this.wadlContext.getJAXBContext();
                            Marshaller marshaller = jaxbContext.createMarshaller();
                            String xslHeader = "<?xml-stylesheet type='text/xsl' href='" + this.getStylesheetLocation(uriInfo) + "'?>";
                            try {
                                marshaller.setProperty("com.sun.xml.internal.bind.xmlHeaders", (Object)xslHeader);
                            }
                            catch (PropertyException propertyException) {
                                marshaller.setProperty("com.sun.xml.bind.xmlHeaders", (Object)xslHeader);
                            }
                            marshaller.setProperty("jaxb.formatted.output", (Object)true);
                            marshaller.marshal((Object)application, (OutputStream)os);
                        }
                        catch (Exception e) {
                            LOG.error("Could not marshal wadl Application. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e), (Object)e);
                            Response response = Response.serverError().build();
                            if (os != null) {
                                os.close();
                            }
                            return response;
                        }
                    }
                    MessageBodyWriter messageBodyWriter = providers.getMessageBodyWriter(Application.class, null, new Annotation[0], v.getMediaType());
                    if (messageBodyWriter == null) {
                        return Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).build();
                    }
                    try {
                        messageBodyWriter.writeTo((Object)application, Application.class, null, new Annotation[0], v.getMediaType(), null, (OutputStream)os);
                    }
                    catch (Exception e) {
                        LOG.error("Could not serialize wadl Application. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e), (Object)e);
                        Response response = Response.serverError().build();
                        if (os != null) {
                            os.close();
                        }
                        return response;
                    }
                    wadlRepresentation = new WadlRepresentation(os.toByteArray());
                    break block28;
                    finally {
                        if (os != null) {
                            os.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (builder2 == null) {
                        builder2 = throwable;
                    } else if (builder2 != throwable) {
                        builder2.addSuppressed(throwable);
                    }
                    throw builder2;
                }
            }
            catch (IOException e) {
                return Response.serverError().entity((Object)ExceptionUtils.getRootCauseMessage((Throwable)e)).build();
            }
        }
        this.wadlRepresentationByBaseUri.put(cacheKey, wadlRepresentation);
        builder2 = Response.ok((Object)new ByteArrayInputStream(wadlRepresentation.wadlXml));
        builder2.tag(eTag);
        builder2.lastModified(wadlRepresentation.lastModified);
        builder2.cacheControl(cc);
        return builder2.build();
    }

    public String getXslStylesheetLocation() {
        return this.xslStylesheetLocation;
    }

    public void setXslStylesheetLocation(String xslStylesheetLocation) {
        this.xslStylesheetLocation = xslStylesheetLocation;
    }

    static class WadlRepresentation {
        final byte[] wadlXml;
        final Date lastModified;

        public WadlRepresentation(byte[] wadlXml) {
            this.wadlXml = wadlXml;
            this.lastModified = new Date();
        }
    }
}

