/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.tests.internal.storage;

import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.context.IModifiableRuntimeContext;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.jobs.IJob;
import org.eclipse.gyrex.jobs.history.IJobHistory;
import org.eclipse.gyrex.jobs.history.IJobHistoryEntry;
import org.eclipse.gyrex.jobs.internal.storage.CloudPreferncesJobHistoryStorage;
import org.eclipse.gyrex.jobs.manager.IJobManager;
import org.eclipse.gyrex.jobs.spi.storage.IJobHistoryStorage;
import org.eclipse.gyrex.jobs.spi.storage.JobHistoryEntryStorable;
import org.eclipse.gyrex.jobs.tests.internal.JobsTestsActivator;
import org.eclipse.gyrex.junit.GyrexServerResource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class CloudHistoryStorageTest {
    @ClassRule
    public static final GyrexServerResource server = new GyrexServerResource();
    private IRuntimeContextRegistry contextRegistry;
    private IModifiableRuntimeContext testContext;
    private CloudPreferncesJobHistoryStorage storage;
    private IJobManager jobManager;

    @BeforeClass
    public static void clearJobHistory() throws Exception {
        String[] childrenNames;
        IEclipsePreferences jobsHistoryNode = CloudPreferncesJobHistoryStorage.getJobsHistoryNode();
        String[] stringArray = childrenNames = jobsHistoryNode.childrenNames();
        int n = childrenNames.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            jobsHistoryNode.node(string).removeNode();
            ++n2;
        }
        jobsHistoryNode.flush();
        Thread.sleep(5000L);
        jobsHistoryNode.sync();
        Thread.sleep(2000L);
    }

    static JobHistoryEntryStorable createHistoryEntry(int severity, String message) {
        JobHistoryEntryStorable e = new JobHistoryEntryStorable();
        e.setTimestamp(System.currentTimeMillis());
        e.setQueuedTrigger("test");
        e.setCancelledTrigger("test-cancel");
        e.setResult((IStatus)new Status(severity, "test", message));
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("param", "arg");
        e.setParameter(p);
        return e;
    }

    private IJobHistory assertHistorySize(String jobId, int expected) {
        IJobHistory jobHistory = this.jobManager.getHistory(jobId);
        Assert.assertNotNull((Object)jobHistory);
        Assert.assertNotNull((Object)jobHistory.getEntries());
        Assert.assertEquals((long)expected, (long)jobHistory.getEntries().size());
        return jobHistory;
    }

    @Before
    public void setUp() throws Exception {
        this.contextRegistry = (IRuntimeContextRegistry)JobsTestsActivator.getInstance().getService(IRuntimeContextRegistry.class);
        this.testContext = this.contextRegistry.get((IPath)Path.ROOT).createWorkingCopy();
        this.storage = new CloudPreferncesJobHistoryStorage((IRuntimeContext)this.testContext);
        this.testContext.setLocal(IJobHistoryStorage.class, (Object)this.storage);
        this.jobManager = (IJobManager)this.testContext.get(IJobManager.class);
    }

    @After
    public void tearDown() throws Exception {
        this.testContext.dispose();
        this.testContext = null;
        this.contextRegistry = null;
        this.storage = null;
        this.jobManager = null;
    }

    @Test
    public void testAddHistory() throws Exception {
        String jobId = "test" + System.nanoTime();
        IJob job = this.jobManager.createJob("tests.testable.job", jobId, null);
        Assert.assertNotNull((Object)job);
        this.assertHistorySize(jobId, 0);
        this.storage.add(jobId, CloudHistoryStorageTest.createHistoryEntry(4, "Error"));
        this.assertHistorySize(jobId, 1);
        this.storage.add(jobId, CloudHistoryStorageTest.createHistoryEntry(1, "Info"));
        IJobHistory jobHistory = this.assertHistorySize(jobId, 2);
        Iterator stream = jobHistory.getEntries().iterator();
        Assert.assertTrue((boolean)stream.hasNext());
        IJobHistoryEntry latest = (IJobHistoryEntry)stream.next();
        Assert.assertNotNull((Object)latest);
        Assert.assertNotNull((Object)latest.getResult());
        Assert.assertEquals((long)1L, (long)latest.getResult().getSeverity());
        Assert.assertTrue((boolean)stream.hasNext());
        IJobHistoryEntry oldest = (IJobHistoryEntry)stream.next();
        Assert.assertNotNull((Object)oldest);
        Assert.assertNotNull((Object)oldest.getResult());
        Assert.assertEquals((long)4L, (long)oldest.getResult().getSeverity());
        Assert.assertFalse((boolean)stream.hasNext());
        try {
            stream.next();
            Assert.fail((String)"missing NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {}
        Assert.assertEquals((long)jobHistory.getEntries().size(), (long)jobHistory.getEntries().toArray().length);
    }

    @Test
    public void testMaxHistorySize() throws Exception {
        String jobId = "test2" + System.nanoTime();
        IJob job = this.jobManager.createJob("tests.testable.job", jobId, null);
        Assert.assertNotNull((Object)job);
        this.assertHistorySize(jobId, 0);
        JobHistoryEntryStorable lastEntry = null;
        int i = 0;
        while (i < 17) {
            lastEntry = CloudHistoryStorageTest.createHistoryEntry(1, "Status " + i);
            this.storage.add(jobId, lastEntry);
            ++i;
        }
        IJobHistory history = this.assertHistorySize(jobId, 10);
        IJobHistoryEntry first = (IJobHistoryEntry)history.getEntries().iterator().next();
        Assert.assertEquals((Object)("INFO: " + lastEntry.getResult().getMessage()), (Object)first.getResult().getMessage());
    }
}

