/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.commands;

import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleManagerImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleStore;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public abstract class BaseScheduleStoreCmd
extends Command {
    @Argument(index=0, usage="specify the schedule storage key", required=true, metaVar="SCHEDULEKEY")
    protected String scheduleStorageKey;
    @Option(name="--process-any-schedule", aliases={"-any"}, usage="process any matching schedule instead of only a specific one (will perform a substring matching of schedule storage key)")
    protected boolean isFilter;

    public BaseScheduleStoreCmd(String description) {
        super("<scheduleStorageKey> " + description);
    }

    protected void doExecute() throws Exception {
        boolean all = StringUtils.equals((String)this.scheduleStorageKey, (String)"*");
        if (all || this.isFilter) {
            String[] schedules;
            String[] stringArray = schedules = ScheduleStore.getSchedules();
            int n = schedules.length;
            int n2 = 0;
            while (n2 < n) {
                String schedule = stringArray[n2];
                if (all || StringUtils.containsIgnoreCase((String)schedule, (String)this.scheduleStorageKey)) {
                    this.doExecute(schedule, ScheduleManagerImpl.getExternalId(schedule));
                }
                ++n2;
            }
        } else {
            if (!IdHelper.isValidId((String)this.scheduleStorageKey)) {
                throw new IllegalArgumentException("invalid storage key");
            }
            this.doExecute(this.scheduleStorageKey, ScheduleManagerImpl.getExternalId(this.scheduleStorageKey));
        }
    }

    protected abstract void doExecute(String var1, String var2) throws Exception;
}

