/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.junit;

import org.eclipse.gyrex.junit.internal.GyrexStarter;
import org.eclipse.gyrex.junit.internal.JUnitActivator;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GyrexServerResource
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(GyrexServerResource.class);
    private boolean hasBeenStarted;

    protected void after() {
        if (this.hasBeenStarted) {
            this.getStarter().requestShutdown();
        }
    }

    protected void before() throws Throwable {
        this.hasBeenStarted = this.getStarter().ensureStartedAndOnline();
        if (!this.hasBeenStarted) {
            LOG.debug("Gyrex server already started by outer rule!");
        }
    }

    private GyrexStarter getStarter() {
        return JUnitActivator.getInstance().getGyrexStarter();
    }
}

