/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.logback.config.internal;

import ch.qos.logback.classic.Level;
import java.util.List;
import java.util.Map;
import org.eclipse.gyrex.logback.config.internal.LogbackConfigActivator;
import org.eclipse.gyrex.logback.config.model.Appender;
import org.eclipse.gyrex.logback.config.model.LogbackConfig;
import org.eclipse.gyrex.logback.config.model.Logger;
import org.eclipse.gyrex.logback.config.spi.AppenderProvider;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferenceBasedLogbackConfigStore {
    private static final String TYPE = "type";
    private static final String LEVEL = "level";
    private static final String INHERIT_OTHER_APPENDERS = "inheritOtherAppenders";
    private static final String APPENDER_REFS = "appenderRefs";
    private static final String LOGGERS = "loggers";
    private static final String APPENDERS = "appenders";
    private static final String DEFAULT_APPENDER_REFS = "defaultAppenderRefs";
    private static final String DEFAULT_LEVEL = "defaultLevel";

    private Appender loadAppender(Preferences node) throws Exception {
        Appender appender;
        String typeId = node.get(TYPE, null);
        AppenderProvider provider = LogbackConfigActivator.getInstance().getAppenderProviderRegistry().getProvider(typeId);
        if (provider != null && (appender = provider.loadAppender(typeId, node)) != null) {
            return appender;
        }
        throw new IllegalArgumentException(String.format("unknown appender type '%s' (appender '%s')", typeId, node.name()));
    }

    public LogbackConfig loadConfig(Preferences node) throws Exception {
        String[] loggers;
        String[] appenders;
        LogbackConfig config = new LogbackConfig();
        String defaultLevel = node.get(DEFAULT_LEVEL, null);
        if (defaultLevel != null) {
            config.setDefaultLevel(Level.toLevel((String)defaultLevel, (Level)Level.INFO));
        }
        String[] stringArray = node.node(DEFAULT_APPENDER_REFS).keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String appender = stringArray[n2];
            config.getDefaultAppenders().add(appender);
            ++n2;
        }
        String[] stringArray2 = appenders = node.node(APPENDERS).childrenNames();
        int n3 = appenders.length;
        n = 0;
        while (n < n3) {
            String appender = stringArray2[n];
            config.addAppender(this.loadAppender(node.node(APPENDERS).node(appender)));
            ++n;
        }
        String[] stringArray3 = loggers = node.node(LOGGERS).childrenNames();
        int n4 = loggers.length;
        n3 = 0;
        while (n3 < n4) {
            String logger = stringArray3[n3];
            config.addLogger(this.loadLogger(logger, node.node(LOGGERS).node(logger)));
            ++n3;
        }
        return config;
    }

    private Logger loadLogger(String name, Preferences node) throws BackingStoreException {
        Logger logger = new Logger();
        logger.setName(name);
        if (node.get(LEVEL, null) != null) {
            logger.setLevel(Level.toLevel((String)node.get(LEVEL, null), (Level)Level.INFO));
        }
        if (node.get(INHERIT_OTHER_APPENDERS, null) != null) {
            logger.setInheritOtherAppenders(node.getBoolean(INHERIT_OTHER_APPENDERS, true));
        }
        String[] stringArray = node.node(APPENDER_REFS).keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String appender = stringArray[n2];
            logger.getAppenderReferences().add(appender);
            ++n2;
        }
        return logger;
    }

    private void saveAppender(Appender appender, Preferences node) throws Exception {
        AppenderProvider provider = LogbackConfigActivator.getInstance().getAppenderProviderRegistry().getProvider(appender.getTypeId());
        if (provider == null) {
            throw new IllegalArgumentException(String.format("unknown appender type '%s' (appender '%s')", appender.getClass().getSimpleName(), appender.getName()));
        }
        provider.writeAppender(appender, node);
        node.put(TYPE, appender.getTypeId());
    }

    private void saveAppenderRefs(List<String> appenderRefs, Preferences appenderRefsNode) throws BackingStoreException {
        if (appenderRefs.isEmpty()) {
            appenderRefsNode.removeNode();
        } else {
            String[] stringArray = appenderRefsNode.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String appender = stringArray[n2];
                if (!appenderRefs.contains(appender)) {
                    appenderRefsNode.remove(appender);
                }
                ++n2;
            }
            for (String appender : appenderRefs) {
                appenderRefsNode.put(appender, "inUse");
            }
        }
    }

    public void saveConfig(LogbackConfig config, Preferences node) throws Exception {
        if (config.getDefaultLevel() != Level.INFO) {
            node.put(DEFAULT_LEVEL, config.getDefaultLevel().toString());
        } else {
            node.remove(DEFAULT_LEVEL);
        }
        this.saveAppenderRefs(config.getDefaultAppenders(), node.node(DEFAULT_APPENDER_REFS));
        Preferences appendersNode = node.node(APPENDERS);
        Map<String, Appender> appenders = config.getAppenders();
        String[] stringArray = appendersNode.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (!appenders.containsKey(string)) {
                appendersNode.node(string).removeNode();
            }
            ++n2;
        }
        for (Appender appender : appenders.values()) {
            this.saveAppender(appender, appendersNode.node(appender.getName()));
        }
        Preferences preferences = node.node(LOGGERS);
        Map<String, Logger> loggers = config.getLoggers();
        String[] stringArray2 = preferences.childrenNames();
        int n3 = stringArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            String logger = stringArray2[n4];
            if (!loggers.containsKey(logger)) {
                preferences.node(logger).removeNode();
            }
            ++n4;
        }
        for (Logger logger : loggers.values()) {
            this.saveLogger(logger, preferences.node(logger.getName()));
        }
        node.flush();
    }

    private void saveLogger(Logger logger, Preferences node) throws BackingStoreException {
        if (logger.getLevel() != null) {
            node.put(LEVEL, logger.getLevel().toString());
        } else {
            node.remove(LEVEL);
        }
        if (!logger.isInheritOtherAppenders()) {
            node.putBoolean(INHERIT_OTHER_APPENDERS, false);
        } else {
            node.remove(INHERIT_OTHER_APPENDERS);
        }
        this.saveAppenderRefs(logger.getAppenderReferences(), node.node(APPENDER_REFS));
    }
}

