/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.p2.internal.commands;

import java.net.URI;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.p2.internal.P2Activator;
import org.eclipse.gyrex.p2.internal.commands.BaseSwCmd;
import org.eclipse.gyrex.p2.internal.packages.InstallableUnitReference;
import org.eclipse.gyrex.p2.internal.packages.PackageDefinition;
import org.eclipse.gyrex.p2.internal.repositories.RepoUtil;
import org.eclipse.gyrex.p2.internal.repositories.RepositoryDefinition;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public final class ListCommand
extends BaseSwCmd {
    @Argument(index=0, usage="specify what to list (repositories, packages or artifacts)", required=true, metaVar="WHAT")
    String what;
    @Argument(index=1, usage="an optional filter string", required=false, metaVar="FILTER")
    String filterString;
    @Option(name="-latest", usage="a flag to search for latest versions only (default is all versions)", required=false)
    boolean latestVersionOnly = false;

    public ListCommand() {
        super("repos|packages|artifacts [filterString] - list repos, packages or artifacts");
    }

    protected void doExecute() throws Exception {
        if (StringUtils.isBlank((String)this.what)) {
            this.printf("ERROR: please specify what to list", new Object[0]);
            return;
        }
        if (StringUtils.startsWithIgnoreCase((String)"repos", (String)this.what)) {
            Collection<RepositoryDefinition> repos = this.getRepositoryManager().getRepositories();
            for (RepositoryDefinition repo : repos) {
                if (this.filterString != null && !StringUtils.contains((String)repo.getId(), (String)this.filterString) && (repo.getLocation() == null || !StringUtils.contains((String)repo.getLocation().toString(), (String)this.filterString))) continue;
                this.ci.println((Object)String.format("%s [%s]", repo.getId(), repo.toString()));
            }
        } else if (StringUtils.startsWithIgnoreCase((String)"packages", (String)this.what)) {
            this.listPackages();
        } else if (StringUtils.startsWithIgnoreCase((String)"artifacts", (String)this.what)) {
            this.listArtifacts();
        } else {
            this.printf("ERROR: repos|packages expected", new Object[0]);
            return;
        }
    }

    private void listArtifacts() throws Exception {
        IProvisioningAgent agent = null;
        try {
            agent = ((IProvisioningAgentProvider)P2Activator.getInstance().getService(IProvisioningAgentProvider.class)).createAgent(null);
            if (agent == null) {
                throw new IllegalStateException("The current system has not been provisioned using p2. Unable to acquire provisioning agent.");
            }
            IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            if (manager == null) {
                throw new IllegalStateException("The provision system is broken. Unable to acquire metadata repository service.");
            }
            RepoUtil.configureRepositories(manager, (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME));
            URI[] knownRepositories = manager.getKnownRepositories(2);
            URI[] uRIArray = knownRepositories;
            int n = knownRepositories.length;
            int n2 = 0;
            while (n2 < n) {
                URI uri = uRIArray[n2];
                this.printf("Loading %s", new Object[]{uri.toString()});
                manager.loadRepository(uri, (IProgressMonitor)new NullProgressMonitor());
                ++n2;
            }
            IQuery query = QueryUtil.createMatchQuery((String)"properties[$0] == true || providedCapabilities.exists(p | p.namespace == 'osgi.bundle')", (Object[])new Object[]{"org.eclipse.equinox.p2.type.group"});
            if (this.latestVersionOnly) {
                query = QueryUtil.createPipeQuery((IQuery)query, (IQuery)QueryUtil.createLatestIUQuery());
            }
            this.printf("Done loading. Searching...", new Object[0]);
            TreeSet<String> result = new TreeSet<String>();
            for (IInstallableUnit iu : manager.query(query, (IProgressMonitor)new NullProgressMonitor())) {
                String id;
                if (iu.getFragments() != null && iu.getFragments().size() > 0 || StringUtils.endsWith((String)(id = iu.getId()), (String)".source") || StringUtils.endsWith((String)id, (String)".source.feature.group")) continue;
                String name = iu.getProperty("org.eclipse.equinox.p2.name", null);
                if (name == null || name.startsWith("%")) {
                    name = "";
                }
                if (!StringUtils.isBlank((String)this.filterString) && !StringUtils.containsIgnoreCase((String)id, (String)this.filterString) && !StringUtils.containsIgnoreCase((String)name, (String)this.filterString)) continue;
                result.add(String.format("%s (%s, %s)", name, id, iu.getVersion()));
            }
            if (result.isEmpty()) {
                this.printf("No artifacts found!", new Object[0]);
            } else {
                this.printf("Found %d artifacts:", new Object[]{result.size()});
                for (String artifact : result) {
                    this.printf(artifact, new Object[0]);
                }
            }
        }
        finally {
            if (agent != null) {
                agent.stop();
            }
        }
    }

    private void listPackages() {
        PackageDefinition definition;
        if (IdHelper.isValidId((String)this.filterString) && (definition = this.getPackageManager().getPackage(this.filterString)) != null) {
            this.printPackage(definition);
            return;
        }
        Collection<PackageDefinition> packages = this.getPackageManager().getPackages();
        for (PackageDefinition pkdefinition : packages) {
            if (this.filterString != null && !StringUtils.contains((String)pkdefinition.getId(), (String)this.filterString)) continue;
            this.printf("%s [%s]", new Object[]{pkdefinition.getId(), pkdefinition.getInstallState()});
        }
    }

    private void printPackage(PackageDefinition p) {
        this.printf("Package %s", new Object[]{p.getId()});
        switch (p.getInstallState()) {
            case ROLLOUT: {
                this.printf("  Is rolled out.", new Object[0]);
                break;
            }
            case REVOKE: {
                this.printf("  Is revoked.", new Object[0]);
                break;
            }
            default: {
                this.printf("  Is neither rolled out nor revoked.", new Object[0]);
            }
        }
        if (StringUtils.isBlank((String)p.getNodeFilter())) {
            this.printf("  Will be installed on all nodes.", new Object[0]);
        } else {
            this.printf("  Will only be installed on nodes matching %.!", new Object[]{p.getNodeFilter()});
        }
        Collection<InstallableUnitReference> componentsToInstall = p.getComponentsToInstall();
        if (!componentsToInstall.isEmpty()) {
            this.printf("  Contains the following artifacts:", new Object[0]);
            for (InstallableUnitReference ref : componentsToInstall) {
                this.printf("     %s (%s)", new Object[]{ref.getId(), ref.getVersion() != null ? ref.getVersion() : "no version constraint"});
            }
        } else {
            this.printf("  Contains no artifacts!", new Object[0]);
        }
    }
}

