/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.p2.internal.packages;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.p2.internal.packages.InstallState;
import org.eclipse.gyrex.p2.internal.packages.InstallableUnitReference;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public final class PackageDefinition {
    private String id;
    private String nodeFilter;
    private InstallState installState;
    private Set<InstallableUnitReference> componentsToInstall;

    public void addComponentToInstall(InstallableUnitReference component) {
        if (this.componentsToInstall == null) {
            this.componentsToInstall = new HashSet<InstallableUnitReference>(3);
        }
        if (!this.componentsToInstall.contains(component)) {
            this.componentsToInstall.add(component);
        }
    }

    public Collection<InstallableUnitReference> getComponentsToInstall() {
        if (this.componentsToInstall != null) {
            return Collections.unmodifiableCollection(this.componentsToInstall);
        }
        return Collections.emptySet();
    }

    public String getId() {
        return this.id;
    }

    public InstallState getInstallState() {
        if (this.installState != null) {
            return this.installState;
        }
        return InstallState.NONE;
    }

    public String getNodeFilter() {
        return this.nodeFilter;
    }

    public boolean removeComponentToInstall(InstallableUnitReference component) {
        if (this.componentsToInstall != null) {
            return this.componentsToInstall.remove(component);
        }
        return false;
    }

    public void setId(String id) {
        if (!IdHelper.isValidId((String)id)) {
            throw new IllegalArgumentException("invalid id");
        }
        this.id = id;
    }

    public void setInstallState(InstallState installState) {
        this.installState = installState;
    }

    public void setNodeFilter(String nodeFilter) throws IllegalArgumentException {
        if (StringUtils.isNotBlank((String)nodeFilter)) {
            try {
                FrameworkUtil.createFilter((String)nodeFilter);
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException("Invalid node filter. Please use LDAP syntax. " + e.getMessage(), e);
            }
        }
        this.nodeFilter = StringUtils.trimToNull((String)nodeFilter);
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("id", (Object)this.id);
        builder.append("componentsToInstall", this.componentsToInstall);
        builder.append("nodeFilter", (Object)this.nodeFilter);
        return builder.toString();
    }
}

