/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.p2.internal.repositories;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.gyrex.cloud.environment.INodeEnvironment;
import org.eclipse.gyrex.p2.internal.P2Activator;
import org.eclipse.gyrex.p2.internal.P2Debug;
import org.eclipse.gyrex.p2.internal.RepoManager;
import org.eclipse.gyrex.p2.internal.repositories.RepositoryDefinition;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepoUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RepoUtil.class);

    public static void configureRepositories(IMetadataRepositoryManager metadataRepositoryManager, IArtifactRepositoryManager artifactRepositoryManager) {
        URI repo;
        if (metadataRepositoryManager == null) {
            throw new IllegalArgumentException("Metadata repository service not available. Please check installation.");
        }
        if (artifactRepositoryManager == null) {
            throw new IllegalArgumentException("Metadata repository service not available. Please check installation.");
        }
        if (P2Debug.debug) {
            LOG.debug("Synchronizing repository information...");
        }
        Map<URI, RepositoryDefinition> repositoriesToInstall = RepoUtil.getFilteredReposMap();
        URI[] uRIArray = metadataRepositoryManager.getKnownRepositories(16);
        int n = uRIArray.length;
        int n2 = 0;
        while (n2 < n) {
            repo = uRIArray[n2];
            metadataRepositoryManager.setEnabled(repo, false);
            ++n2;
        }
        uRIArray = artifactRepositoryManager.getKnownRepositories(16);
        n = uRIArray.length;
        n2 = 0;
        while (n2 < n) {
            repo = uRIArray[n2];
            artifactRepositoryManager.setEnabled(repo, false);
            ++n2;
        }
        for (URI uri : repositoriesToInstall.keySet()) {
            RepositoryDefinition definition = repositoriesToInstall.get(uri);
            if (P2Debug.debug) {
                LOG.debug("Adding repository: {}", (Object)definition);
            }
            metadataRepositoryManager.addRepository(uri);
            metadataRepositoryManager.setRepositoryProperty(uri, "p2.nickname", definition.getId());
            artifactRepositoryManager.addRepository(uri);
            artifactRepositoryManager.setRepositoryProperty(uri, "p2.nickname", definition.getId());
        }
    }

    public static URI[] getFilteredRepositories() {
        RepoManager repositoryDefinitionManager = P2Activator.getInstance().getRepositoryManager();
        Collection<RepositoryDefinition> repositories = repositoryDefinitionManager.getRepositories();
        ArrayList<URI> repositoriesToInstall = new ArrayList<URI>(repositories.size());
        for (RepositoryDefinition repositoryDefinition : repositories) {
            URI location;
            block5: {
                String nodeFilter = repositoryDefinition.getNodeFilter();
                if (StringUtils.isNotBlank((String)nodeFilter)) {
                    try {
                        if (!((INodeEnvironment)P2Activator.getInstance().getService(INodeEnvironment.class)).matches(nodeFilter)) {
                        }
                        break block5;
                    }
                    catch (InvalidSyntaxException e) {
                        LOG.warn("Invalid node filter for repository {}. Repository will be ignored. {}", (Object)repositoryDefinition.getId(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                    }
                    continue;
                }
            }
            if ((location = repositoryDefinition.getLocation()) == null) continue;
            repositoriesToInstall.add(location);
        }
        return repositoriesToInstall.toArray(new URI[repositoriesToInstall.size()]);
    }

    private static Map<URI, RepositoryDefinition> getFilteredReposMap() {
        RepoManager repositoryDefinitionManager = P2Activator.getInstance().getRepositoryManager();
        Collection<RepositoryDefinition> repositories = repositoryDefinitionManager.getRepositories();
        HashMap<URI, RepositoryDefinition> repositoriesToInstall = new HashMap<URI, RepositoryDefinition>(repositories.size());
        for (RepositoryDefinition repositoryDefinition : repositories) {
            URI location;
            block5: {
                String nodeFilter = repositoryDefinition.getNodeFilter();
                if (StringUtils.isNotBlank((String)nodeFilter)) {
                    try {
                        if (!((INodeEnvironment)P2Activator.getInstance().getService(INodeEnvironment.class)).matches(nodeFilter)) {
                        }
                        break block5;
                    }
                    catch (InvalidSyntaxException e) {
                        LOG.warn("Invalid node filter for repository {}. Repository will be ignored. {}", (Object)repositoryDefinition.getId(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                    }
                    continue;
                }
            }
            if ((location = repositoryDefinition.getLocation()) == null) continue;
            repositoriesToInstall.put(location, repositoryDefinition);
        }
        return repositoriesToInstall;
    }

    private RepoUtil() {
    }
}

