/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.solr.internal;

import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.LBHttpSolrServer;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.eclipse.gyrex.monitoring.metrics.ThroughputMetric;
import org.eclipse.gyrex.persistence.solr.internal.SolrRepositoryMetrics;

public class SolrServerWithMetrics
extends SolrServer {
    private static final long serialVersionUID = 7409277302681086835L;
    private final SolrServer server;
    private final SolrRepositoryMetrics metrics;
    private final ThroughputMetric queryThroughput;
    private final ThroughputMetric updateThroughput;
    private final ThroughputMetric adminThroughput;
    private final ThroughputMetric otherThroughput;

    public SolrServerWithMetrics(SolrServer server, SolrRepositoryMetrics metrics) {
        this.server = server;
        this.metrics = metrics;
        this.queryThroughput = metrics.getQueryThroughputMetric();
        this.updateThroughput = metrics.getUpdateThroughputMetric();
        this.adminThroughput = metrics.getAdminThroughputMetric();
        this.otherThroughput = metrics.getOtherThroughputMetric();
    }

    private ThroughputMetric getRequestMetric(SolrRequest request) {
        if (request instanceof QueryRequest) {
            return this.queryThroughput;
        }
        if (request instanceof AbstractUpdateRequest) {
            return this.updateThroughput;
        }
        if (request instanceof CoreAdminRequest) {
            return this.adminThroughput;
        }
        return this.otherThroughput;
    }

    private void recordException(SolrRequest request, Exception e) {
        StringBuilder requestInfo = new StringBuilder();
        requestInfo.append(request.getClass().getSimpleName());
        requestInfo.append('[');
        requestInfo.append(request.getMethod());
        requestInfo.append(' ');
        requestInfo.append(request.getPath());
        SolrParams params = request.getParams();
        if (params != null) {
            requestInfo.append(' ');
            requestInfo.append(request.getParams().toNamedList());
        }
        requestInfo.append(']');
        this.metrics.recordException(requestInfo.toString(), e);
    }

    public NamedList<Object> request(SolrRequest request) throws SolrServerException, IOException {
        ThroughputMetric requestMetric = this.getRequestMetric(request);
        long requestStarted = requestMetric.requestStarted();
        try {
            NamedList result = this.server.request(request);
            requestMetric.requestFinished((long)result.size(), System.currentTimeMillis() - requestStarted);
            return result;
        }
        catch (IOException e) {
            requestMetric.requestFailed();
            this.recordException(request, e);
            throw e;
        }
        catch (SolrServerException e) {
            requestMetric.requestFailed();
            this.recordException(request, (Exception)((Object)e));
            throw e;
        }
    }

    public void shutdown() {
    }

    public String toString() {
        StringBuilder toString = new StringBuilder();
        toString.append(this.server.getClass().getSimpleName()).append(" {");
        try {
            toString.append(this.server.getClass().getMethod("getBaseURL", new Class[0]).invoke((Object)this.server, new Object[0]));
        }
        catch (Exception exception) {}
        if (this.server instanceof EmbeddedSolrServer) {
            try {
                toString.append(EmbeddedSolrServer.class.getDeclaredField("coreName").get(this.server));
            }
            catch (Exception e) {
                toString.append(ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        } else if (this.server instanceof LBHttpSolrServer) {
            LBHttpSolrServer lbHttpSolrServer = (LBHttpSolrServer)this.server;
            try {
                Iterator zombies;
                Iterator alive = ((CopyOnWriteArrayList)LBHttpSolrServer.class.getDeclaredField("aliveServers").get(lbHttpSolrServer)).iterator();
                if (alive.hasNext()) {
                    toString.append("alive:").append(StringUtils.join(alive, (char)';'));
                }
                if ((zombies = ((CopyOnWriteArrayList)LBHttpSolrServer.class.getDeclaredField("zombieServers").get(lbHttpSolrServer)).iterator()).hasNext()) {
                    toString.append(" zombie:").append(StringUtils.join(zombies, (char)';'));
                }
            }
            catch (Exception e) {
                toString.append(ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        toString.append("}");
        return toString.toString();
    }
}

