/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.search.internal.solr.documents;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.common.SolrDocument;
import org.eclipse.gyrex.search.documents.IDocumentAttribute;
import org.eclipse.gyrex.search.internal.solr.documents.BaseDocument;
import org.eclipse.gyrex.search.internal.solr.documents.BaseDocumentAttribute;
import org.eclipse.gyrex.search.internal.solr.documents.StoredDocumentAttribute;

public class StoredDocument
extends BaseDocument {
    private final SolrDocument doc;
    private final Map<String, IDocumentAttribute<?>> attributes = new HashMap();
    private boolean dirty;
    private boolean initializedFully;

    public StoredDocument(SolrDocument doc) {
        this.doc = doc;
    }

    @Override
    public boolean contains(String attributeId) {
        return this.doc.containsKey((Object)attributeId);
    }

    private void ensureInitialized(String attributeId) {
        if (!this.initializedFully && !this.attributes.containsKey(attributeId)) {
            this.attributes.put(attributeId, new StoredDocumentAttribute(attributeId, this.doc.getFieldValues(attributeId), this));
        }
    }

    private void ensureInitializedFully() {
        if (!this.initializedFully) {
            for (String key : this.doc.keySet()) {
                this.ensureInitialized(key);
            }
            this.initializedFully = true;
        }
    }

    @Override
    public IDocumentAttribute<?> get(String attributeId) {
        this.ensureInitialized(attributeId);
        return this.attributes.get(attributeId);
    }

    @Override
    public Map<String, IDocumentAttribute<?>> getAttributes() {
        this.ensureInitializedFully();
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public IDocumentAttribute<?> getOrCreate(String attributeId) {
        this.ensureInitializedFully();
        IDocumentAttribute<?> attribute = this.attributes.get(attributeId);
        if (attribute == null) {
            attribute = new BaseDocumentAttribute(attributeId);
            this.attributes.put(attributeId, attribute);
            this.setDirty(true);
        }
        return attribute;
    }

    @Override
    public Object getValue(String attributeId) {
        this.ensureInitialized(attributeId);
        IDocumentAttribute<?> attribute = this.attributes.get(attributeId);
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isTransient() {
        return false;
    }

    @Override
    public IDocumentAttribute<?> remove(String attributeId) {
        this.ensureInitializedFully();
        IDocumentAttribute<?> removed = this.attributes.remove(attributeId);
        this.setDirty(removed != null);
        return removed;
    }

    void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public String toString() {
        this.ensureInitializedFully();
        return String.valueOf(this.dirty ? "StoredDocument[DIRTY]{" : "StoredDocument{") + this.attributes.values().toString().replace('\n', '|').replace('\r', ' ') + "}";
    }
}

