/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lookup;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrecedenceBinding
extends Binding {
    public static final PrecedenceBinding[] NoPrecedences = new PrecedenceBinding[0];
    public ReferenceBinding enclosingType;
    private Binding[] elements;

    public PrecedenceBinding(ReferenceBinding enclosingType, NameReference[] callinNames) {
        this.enclosingType = enclosingType;
        this.elements = new Binding[callinNames.length];
        int i = 0;
        while (i < callinNames.length) {
            this.elements[i] = callinNames[i].binding;
            ++i;
        }
    }

    public PrecedenceBinding(LinkedList<CallinCalloutBinding> bindingNames) {
        int len = bindingNames.size();
        this.elements = new Binding[len];
        int i = 0;
        Iterator iter = bindingNames.iterator();
        while (iter.hasNext()) {
            this.elements[i++] = (Binding)iter.next();
        }
    }

    public PrecedenceBinding(ReferenceBinding enclosingType, CallinCalloutBinding[] mappings) {
        this.enclosingType = enclosingType;
        this.elements = mappings;
    }

    @Override
    public int kind() {
        return 32768;
    }

    public boolean hasCommonBaseMethod(PrecedenceBinding other) {
        int j;
        MethodBinding[] baseMethods;
        HashSet<MethodBinding> otherBaseMethods = new HashSet<MethodBinding>();
        int i = 0;
        while (i < other.elements.length) {
            if (other.elements[i] != null && other.elements[i].isValidBinding() && other.elements[i].kind() == 16384) {
                CallinCalloutBinding otherMapping = (CallinCalloutBinding)other.elements[i];
                baseMethods = otherMapping._baseMethods;
                j = 0;
                while (j < baseMethods.length) {
                    otherBaseMethods.add(baseMethods[j]);
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < other.elements.length) {
            if (this.elements[i] != null && this.elements[i].isValidBinding() && this.elements[i].kind() == 16384) {
                CallinCalloutBinding mapping = (CallinCalloutBinding)this.elements[i];
                baseMethods = mapping._baseMethods;
                j = 0;
                while (j < baseMethods.length) {
                    if (otherBaseMethods.contains(baseMethods[j])) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    private static boolean hasCommonBaseMethod(CallinCalloutBinding b1, CallinCalloutBinding b2, Scope scope) {
        MethodBinding[] methodBindingArray = b1._baseMethods;
        int n = b1._baseMethods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding m1 = methodBindingArray[n2];
            MethodBinding[] methodBindingArray2 = b2._baseMethods;
            int n3 = b2._baseMethods.length;
            int n4 = 0;
            while (n4 < n3) {
                MethodBinding m2 = methodBindingArray2[n4];
                if ((m1 == m2 || !m1.isStatic() && !m2.isStatic() && CharOperation.equals(m1.selector, m2.selector) && CharOperation.equals(m1.signature(), m2.signature()) && (m1.declaringClass.isCompatibleWith(m2.declaringClass) || m2.declaringClass.isCompatibleWith(m1.declaringClass))) && !PrecedenceBinding.isDiscriminatedByClassBindings(m1, m2, b1, b2, scope)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isDiscriminatedByClassBindings(MethodBinding bm1, MethodBinding bm2, CallinCalloutBinding ci1, CallinCalloutBinding ci2, Scope scope) {
        ReferenceBinding role1 = ci1._declaringRoleClass;
        ReferenceBinding role2 = ci2._declaringRoleClass;
        if (role1 == role2) {
            return false;
        }
        ReferenceBinding base1 = role1.baseclass();
        ReferenceBinding base2 = role2.baseclass();
        if (base1 == null || base2 == null) {
            return false;
        }
        if (bm1.isStatic() && base1 != base2) {
            return true;
        }
        return !base1.isCompatibleWith(base2) && !base2.isCompatibleWith(base1);
    }

    public static void checkDuplicates(TypeDeclaration teamDecl) {
        CallinCalloutBinding[] callinCallouts = teamDecl.binding.allCallins();
        if (callinCallouts.length < 2) {
            return;
        }
        int i = 0;
        while (i < callinCallouts.length) {
            if (callinCallouts[i].type == 1) {
                int j = i + 1;
                while (j < callinCallouts.length) {
                    if (callinCallouts[j].type == 1 && PrecedenceBinding.isPrecedenceMissing(teamDecl.binding.precedences, callinCallouts[i], callinCallouts[j], teamDecl.scope)) {
                        teamDecl.scope.problemReporter().unknownPrecedence(teamDecl, callinCallouts[i], callinCallouts[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static boolean isPrecedenceMissing(PrecedenceBinding[] precedences, CallinCalloutBinding callin1, CallinCalloutBinding callin2, Scope scope) {
        if (callin1.callinModifier == callin2.callinModifier && PrecedenceBinding.hasCommonBaseMethod(callin1, callin2, scope)) {
            if (precedences != null) {
                int k = 0;
                while (k < precedences.length) {
                    if (precedences[k].containsBoth(callin1, callin2)) {
                        return false;
                    }
                    ++k;
                }
            }
            ReferenceBinding role1 = callin1._declaringRoleClass;
            ReferenceBinding role2 = callin2._declaringRoleClass;
            if (CharOperation.equals(callin1.name, callin2.name) && (role1.isCompatibleWith(role2) || role2.isCompatibleWith(role1))) {
                return false;
            }
            return TeamModel.areCompatibleEnclosings(role1.enclosingType(), role2.enclosingType());
        }
        return false;
    }

    public CallinCalloutBinding[] callins(boolean shallEliminateOverrides) {
        if (this.elements instanceof CallinCalloutBinding[]) {
            return (CallinCalloutBinding[])this.elements;
        }
        LinkedList<CallinCalloutBinding> callins = new LinkedList<CallinCalloutBinding>();
        boolean hasChangedLength = false;
        int i = 0;
        while (i < this.elements.length) {
            if (this.elements[i] != null) {
                if (this.elements[i].kind() == 16384) {
                    callins.add((CallinCalloutBinding)this.elements[i]);
                } else {
                    hasChangedLength = true;
                    this.addCallins((ReferenceBinding)this.elements[i], callins);
                }
            }
            ++i;
        }
        if (shallEliminateOverrides) {
            hasChangedLength |= this.eliminateOverrides(callins);
        }
        CallinCalloutBinding[] result = new CallinCalloutBinding[callins.size()];
        if (hasChangedLength) {
            callins.toArray(result);
        } else {
            System.arraycopy(this.elements, 0, result, 0, result.length);
        }
        this.elements = result;
        return result;
    }

    private boolean eliminateOverrides(LinkedList<CallinCalloutBinding> callins) {
        boolean hasChanged = false;
        int i = 1;
        while (i < callins.size()) {
            CallinCalloutBinding callin_i = callins.get(i);
            int j = 0;
            while (j < i) {
                CallinCalloutBinding callin_j = callins.get(j);
                if (CharOperation.equals(callin_j.name, callin_i.name)) {
                    if (callin_j._declaringRoleClass.isCompatibleWith(callin_i._declaringRoleClass)) {
                        hasChanged = true;
                        callins.remove(i);
                        --i;
                        break;
                    }
                    if (callin_i._declaringRoleClass.isCompatibleWith(callin_j._declaringRoleClass)) {
                        hasChanged = true;
                        callins.remove(j);
                        break;
                    }
                }
                ++j;
            }
            ++i;
        }
        return hasChanged;
    }

    private boolean containsBoth(CallinCalloutBinding callin1, CallinCalloutBinding callin2) {
        int numFound = 0;
        int i = 0;
        while (i < this.elements.length) {
            Binding element = this.elements[i];
            if (element != null) {
                if (element.kind() == 16384) {
                    if (this.sameOrOverridingBinding((CallinCalloutBinding)element, callin1)) {
                        ++numFound;
                    }
                    if (this.sameOrOverridingBinding((CallinCalloutBinding)element, callin2)) {
                        ++numFound;
                    }
                } else {
                    ReferenceBinding roleType = (ReferenceBinding)element;
                    roleType = roleType.roleModel.getClassPartBinding();
                    if (roleType == callin1._declaringRoleClass) {
                        ++numFound;
                    }
                    if (roleType == callin2._declaringRoleClass) {
                        ++numFound;
                    }
                }
                if (numFound == 2) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean sameOrOverridingBinding(CallinCalloutBinding callin1, CallinCalloutBinding callin2) {
        if (callin1 == callin2) {
            return true;
        }
        if (!CharOperation.equals(callin1.name, callin2.name)) {
            return false;
        }
        return callin1._declaringRoleClass.isCompatibleWith(callin2._declaringRoleClass) || callin2._declaringRoleClass.isCompatibleWith(callin1._declaringRoleClass);
    }

    private void addCallins(ReferenceBinding type, LinkedList<CallinCalloutBinding> result) {
        CallinCalloutBinding[] callins;
        int i;
        type = type.roleModel.getClassPartBinding();
        if (type == null) {
            return;
        }
        HashSet<CallinCalloutBinding> added = new HashSet<CallinCalloutBinding>();
        if (type.precedences != null) {
            i = 0;
            while (i < type.precedences.length) {
                PrecedenceBinding precedenceBinding = type.precedences[i];
                callins = precedenceBinding.callins(false);
                int j = 0;
                while (j < callins.length) {
                    if (!added.contains(callins[j])) {
                        added.add(callins[j]);
                        result.add(callins[j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        if ((callins = type.callinCallouts) != null) {
            i = 0;
            while (i < callins.length) {
                if (callins[i].type == 1 && !added.contains(callins[i])) {
                    added.add(callins[i]);
                    result.add(callins[i]);
                }
                ++i;
            }
        }
    }

    @Override
    public char[] readableName() {
        char[][] names = new char[this.elements.length][];
        int i = 0;
        while (i < this.elements.length) {
            names[i] = this.elements[i] == null ? "<unresolved>".toCharArray() : (this.elements[i].kind() == 16384 ? ((CallinCalloutBinding)this.elements[i]).name : ((ReferenceBinding)this.elements[i]).sourceName());
            ++i;
        }
        return CharOperation.concatWith(names, ',');
    }

    public String toString() {
        return new String(this.readableName());
    }
}

