/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.AbstractTransformStatementsVisitor;

public class ReplaceSingleNameVisitor
extends AbstractTransformStatementsVisitor {
    private IExpressionProvider _provider;
    private char[] _name;
    private boolean _hasChanges;

    public ReplaceSingleNameVisitor(char[] name, IExpressionProvider provider) {
        this._name = name;
        this._provider = provider;
    }

    public static boolean performReplacement(ASTNode node, BlockScope scope, char[] oldName, final char[] newName) {
        final int start = node.sourceStart;
        IExpressionProvider provider = new IExpressionProvider(){

            public Expression newExpression() {
                return new SingleNameReference(newName, start);
            }
        };
        ReplaceSingleNameVisitor replaceSingleNameVisitor = new ReplaceSingleNameVisitor(oldName, provider);
        node.traverse(replaceSingleNameVisitor, scope);
        return replaceSingleNameVisitor._hasChanges;
    }

    protected void enterExpression(Expression oldExpr, Expression newExpr, Statement node) {
        throw new InternalCompilerError("Method not applicable");
    }

    protected boolean testExpression(Statement oldExpr) {
        if (!(oldExpr instanceof SingleNameReference)) {
            return false;
        }
        return CharOperation.equals(((SingleNameReference)oldExpr).token, this._name);
    }

    protected void assertAllConsumed(ASTNode node) {
    }

    protected Expression consumeExpression() {
        this._hasChanges = true;
        return this._provider.newExpression();
    }

    protected Expression checkConsumeExpression(Expression oldExpr, BlockScope scope) {
        if (this.testExpression(oldExpr)) {
            this._hasChanges = true;
            return this._provider.newExpression();
        }
        return oldExpr;
    }

    protected Statement checkConsumeStatement(Statement oldStat, BlockScope scope) {
        if (this.testExpression(oldStat)) {
            this._hasChanges = true;
            return this._provider.newExpression();
        }
        return oldStat;
    }

    public static interface IExpressionProvider {
        public Expression newExpression();
    }
}

