/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.ui.compare.JavaNode;

class JavaParseTreeBuilder
extends ASTVisitor {
    private char[] fBuffer;
    private Stack<JavaNode> fStack = new Stack();
    private JavaNode fImportContainer;
    private boolean fShowCU;

    JavaParseTreeBuilder(JavaNode root, char[] buffer, boolean showCU) {
        this.fBuffer = buffer;
        this.fShowCU = showCU;
        this.fStack.clear();
        this.fStack.push(root);
    }

    public boolean visit(PackageDeclaration node) {
        new JavaNode(this.getCurrentContainer(), 1, null, node.getStartPosition(), node.getLength());
        return false;
    }

    public boolean visit(CompilationUnit node) {
        if (this.fShowCU) {
            this.push(0, null, node.getStartPosition(), node.getLength());
        }
        return true;
    }

    public void endVisit(CompilationUnit node) {
        if (this.fShowCU) {
            this.pop();
        }
    }

    public boolean visit(TypeDeclaration node) {
        this.push(node.isInterface() ? 4 : 5, node.getName().toString(), node.getStartPosition(), node.getLength());
        return true;
    }

    public void endVisit(TypeDeclaration node) {
        this.pop();
    }

    public boolean visit(EnumDeclaration node) {
        this.push(6, node.getName().toString(), node.getStartPosition(), node.getLength());
        return true;
    }

    public void endVisit(EnumDeclaration node) {
        this.pop();
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        this.push(7, node.getName().toString(), node.getStartPosition(), node.getLength());
        return true;
    }

    public void endVisit(AnnotationTypeDeclaration node) {
        this.pop();
    }

    public boolean visit(AnnotationTypeMemberDeclaration node) {
        this.push(11, this.getSignature(node), node.getStartPosition(), node.getLength());
        return true;
    }

    public void endVisit(AnnotationTypeMemberDeclaration node) {
        this.pop();
    }

    public boolean visit(MethodDeclaration node) {
        String signature = this.getSignature(node);
        this.push(node.isConstructor() ? 10 : 11, signature, node.getStartPosition(), node.getLength());
        return false;
    }

    public void endVisit(MethodDeclaration node) {
        this.pop();
    }

    public boolean visit(Initializer node) {
        this.push(9, this.getCurrentContainer().getInitializerCount(), node.getStartPosition(), node.getLength());
        return false;
    }

    public void endVisit(Initializer node) {
        this.pop();
    }

    public boolean visit(ImportDeclaration node) {
        int s = node.getStartPosition();
        int l = node.getLength();
        int declarationEnd = s + l;
        if (this.fImportContainer == null) {
            this.fImportContainer = new JavaNode(this.getCurrentContainer(), 2, null, s, l);
        }
        String nm = node.getName().toString();
        if (node.isOnDemand()) {
            nm = String.valueOf(nm) + ".*";
        }
        new JavaNode(this.fImportContainer, 3, nm, s, l);
        this.fImportContainer.setLength(declarationEnd - this.fImportContainer.getRange().getOffset() + 1);
        this.fImportContainer.setAppendPosition(declarationEnd + 2);
        return false;
    }

    public boolean visit(VariableDeclarationFragment node) {
        String name = this.getFieldName(node);
        ASTNode parent = node.getParent();
        this.push(8, name, parent.getStartPosition(), parent.getLength());
        return false;
    }

    public void endVisit(VariableDeclarationFragment node) {
        this.pop();
    }

    public boolean visit(EnumConstantDeclaration node) {
        this.push(8, node.getName().toString(), node.getStartPosition(), node.getLength());
        return false;
    }

    public void endVisit(EnumConstantDeclaration node) {
        this.pop();
    }

    private void push(int type, String name, int declarationStart, int length) {
        while (declarationStart > 0) {
            char c = this.fBuffer[declarationStart - 1];
            if (c != ' ' && c != '\t') break;
            --declarationStart;
            ++length;
        }
        JavaNode node = new JavaNode(this.getCurrentContainer(), type, name, declarationStart, length);
        if (type == 0) {
            node.setAppendPosition(declarationStart + length + 1);
        } else {
            node.setAppendPosition(declarationStart + length);
        }
        this.fStack.push(node);
    }

    private void pop() {
        this.fStack.pop();
    }

    private JavaNode getCurrentContainer() {
        return this.fStack.peek();
    }

    private String getFieldName(VariableDeclarationFragment node) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(node.getName().toString());
        ASTNode parent = node.getParent();
        if (parent instanceof FieldDeclaration) {
            FieldDeclaration fd = (FieldDeclaration)parent;
            buffer.append(" : ");
            buffer.append(this.getType(fd.getType()));
        }
        return buffer.toString();
    }

    private String getSignature(MethodDeclaration node) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(node.getName().toString());
        buffer.append('(');
        boolean first = true;
        for (SingleVariableDeclaration svd : node.parameters()) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(this.getType(svd.getType()));
            if (svd.isVarargs()) {
                buffer.append("...");
            }
            first = false;
        }
        buffer.append(')');
        return buffer.toString();
    }

    private String getSignature(AnnotationTypeMemberDeclaration node) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(node.getName().toString());
        buffer.append('(');
        buffer.append(')');
        return buffer.toString();
    }

    private String getType(Type type) {
        String name = type.toString();
        int pos = name.lastIndexOf(46);
        if (pos >= 0) {
            name = name.substring(pos + 1);
        }
        return name;
    }
}

