/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.archive;

import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveCommand
extends GitCommand<OutputStream> {
    private static final Map<Format, Archiver> formats;
    private OutputStream out;
    private TreeWalk walk;
    private Format format = Format.TAR;

    public ArchiveCommand(Repository repo) {
        super(repo);
        this.walk = new TreeWalk(repo);
    }

    public void release() {
        this.walk.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream call() throws GitAPIException {
        MutableObjectId idBuf = new MutableObjectId();
        Archiver fmt = formats.get((Object)this.format);
        ArchiveOutputStream outa = fmt.createArchiveOutputStream(this.out);
        ObjectReader reader = this.walk.getObjectReader();
        try {
            try {
                this.walk.setRecursive(true);
                while (this.walk.next()) {
                    String name = this.walk.getPathString();
                    FileMode mode = this.walk.getFileMode(0);
                    if (mode == FileMode.TREE) continue;
                    this.walk.getObjectId(idBuf, 0);
                    fmt.putEntry(name, mode, reader.open((AnyObjectId)idBuf), outa);
                }
            }
            finally {
                outa.close();
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(CLIText.get().exceptionCaughtDuringExecutionOfArchiveCommand, (Throwable)e);
        }
        return this.out;
    }

    public ArchiveCommand setTree(ObjectId tree) throws IOException {
        RevWalk rw = new RevWalk(this.walk.getObjectReader());
        this.walk.reset((AnyObjectId)rw.parseTree((AnyObjectId)tree));
        return this;
    }

    public ArchiveCommand setOutputStream(OutputStream out) {
        this.out = out;
        return this;
    }

    public ArchiveCommand setFormat(Format fmt) {
        this.format = fmt;
        return this;
    }

    static {
        EnumMap<Format, Archiver> fmts = new EnumMap<Format, Archiver>(Format.class);
        fmts.put(Format.ZIP, new Archiver(){

            public ArchiveOutputStream createArchiveOutputStream(OutputStream s) {
                return new ZipArchiveOutputStream(s);
            }

            public void putEntry(String path, FileMode mode, ObjectLoader loader, ArchiveOutputStream out) throws IOException {
                ZipArchiveEntry entry = new ZipArchiveEntry(path);
                if (mode != FileMode.REGULAR_FILE && (mode == FileMode.EXECUTABLE_FILE || mode == FileMode.SYMLINK)) {
                    entry.setUnixMode(mode.getBits());
                }
                entry.setSize(loader.getSize());
                out.putArchiveEntry((ArchiveEntry)entry);
                loader.copyTo((OutputStream)out);
                out.closeArchiveEntry();
            }
        });
        fmts.put(Format.TAR, new Archiver(){

            public ArchiveOutputStream createArchiveOutputStream(OutputStream s) {
                return new TarArchiveOutputStream(s);
            }

            public void putEntry(String path, FileMode mode, ObjectLoader loader, ArchiveOutputStream out) throws IOException {
                if (mode == FileMode.SYMLINK) {
                    TarArchiveEntry entry = new TarArchiveEntry(path, 50);
                    entry.setLinkName(new String(loader.getCachedBytes(100), "UTF-8"));
                    out.putArchiveEntry((ArchiveEntry)entry);
                    out.closeArchiveEntry();
                    return;
                }
                TarArchiveEntry entry = new TarArchiveEntry(path);
                if (mode == FileMode.REGULAR_FILE || mode == FileMode.EXECUTABLE_FILE) {
                    entry.setMode(mode.getBits());
                }
                entry.setSize(loader.getSize());
                out.putArchiveEntry((ArchiveEntry)entry);
                loader.copyTo((OutputStream)out);
                out.closeArchiveEntry();
            }
        });
        formats = fmts;
    }

    private static interface Archiver {
        public ArchiveOutputStream createArchiveOutputStream(OutputStream var1);

        public void putEntry(String var1, FileMode var2, ObjectLoader var3, ArchiveOutputStream var4) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        ZIP,
        TAR;

    }
}

