/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public final class ControlTools {
    public static void center(Control control) {
        control.setBounds(ControlTools.calculateCenteredBounds(control.getBounds(), control.getDisplay().getBounds()));
    }

    public static void center(Control control, Control parentControl) {
        control.setBounds(ControlTools.calculateCenteredBounds(control.getBounds(), parentControl.getBounds()));
    }

    public static Rectangle calculateCenteredBounds(Rectangle rectangle1, Rectangle rectangle2) {
        return ControlTools.calculateCenteredBounds(rectangle1.width, rectangle1.height, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    public static Rectangle calculateCenteredBounds(Point size1, Point size2) {
        return ControlTools.calculateCenteredBounds(size1.x, size1.y, size2.x, size2.y);
    }

    public static Rectangle calculateCenteredBounds(int width1, int height1, int width2, int height2) {
        return ControlTools.calculateCenteredBounds(width1, height1, 0, 0, width2, height2);
    }

    public static Rectangle calculateCenteredBounds(int width1, int height1, int x2, int y2, int width2, int height2) {
        return new Rectangle(x2 + (width2 - width1 >> 1), y2 + (height2 - height1 >> 1), width1, height1);
    }

    public static Point calculateCenteredPosition(Rectangle rectangle1, Rectangle rectangle2) {
        return ControlTools.calculateCenteredPosition(rectangle1.width, rectangle1.height, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    public static Point calculateCenteredPosition(Point size1, Point size2) {
        return ControlTools.calculateCenteredPosition(size1.x, size1.y, size2.x, size2.y);
    }

    public static Point calculateCenteredPosition(int width1, int height1, int width2, int height2) {
        return ControlTools.calculateCenteredPosition(width1, height1, 0, 0, width2, height2);
    }

    public static Point calculateCenteredPosition(int width1, int height1, int x2, int y2, int width2, int height2) {
        return new Point(x2 + (width2 - width1 >> 1), y2 + (height2 - height1 >> 1));
    }

    public static void reflow(Control control) {
        ControlTools.reflow(control instanceof Composite ? (Composite)control : control.getParent());
    }

    public static void reflow(Composite composite) {
        Composite c = composite;
        while (c != null) {
            c.setRedraw(false);
            c = c.getParent();
            if (c instanceof SharedScrolledComposite || c instanceof Shell) break;
        }
        for (c = composite; c != null; c = c.getParent()) {
            c.layout(true);
            if (!(c instanceof SharedScrolledComposite)) continue;
            ((ScrolledForm)c).reflow(true);
            break;
        }
        c = composite;
        while (c != null) {
            c.setRedraw(true);
            c = c.getParent();
            if (c instanceof SharedScrolledComposite || c instanceof Shell) break;
        }
    }

    private ControlTools() {
        throw new UnsupportedOperationException();
    }
}

