/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa2.context.java;

import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.core.jpa2.context.Cacheable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaCacheableReference2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.CacheableAnnotation2_0;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaCacheable2_0
extends AbstractJavaContextModel<JavaCacheableReference2_0>
implements Cacheable2_0 {
    protected Boolean specifiedCacheable = this.buildSpecifiedCacheable();
    protected boolean defaultCacheable;

    public GenericJavaCacheable2_0(JavaCacheableReference2_0 parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedCacheable_(this.buildSpecifiedCacheable());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultCacheable(this.buildDefaultCacheable());
    }

    @Override
    public boolean isCacheable() {
        return this.specifiedCacheable != null ? this.specifiedCacheable : this.defaultCacheable;
    }

    @Override
    public Boolean getSpecifiedCacheable() {
        return this.specifiedCacheable;
    }

    @Override
    public void setSpecifiedCacheable(Boolean cacheable) {
        if (this.valuesAreDifferent(cacheable, this.specifiedCacheable)) {
            if (cacheable == null) {
                this.removeCacheableAnnotation();
            } else {
                CacheableAnnotation2_0 annotation = this.getCacheableAnnotationForUpdate();
                Boolean value = annotation.getValue();
                if (cacheable.booleanValue()) {
                    if (value != null && !value.booleanValue()) {
                        annotation.setValue(null);
                    }
                } else {
                    annotation.setValue(Boolean.FALSE);
                }
            }
            this.setSpecifiedCacheable_(cacheable);
        }
    }

    protected void setSpecifiedCacheable_(Boolean cacheable) {
        Boolean old = this.specifiedCacheable;
        this.specifiedCacheable = cacheable;
        this.firePropertyChanged("specifiedCacheable", old, cacheable);
    }

    private Boolean buildSpecifiedCacheable() {
        CacheableAnnotation2_0 annotation = this.getCacheableAnnotation();
        if (annotation == null) {
            return null;
        }
        Boolean value = annotation.getValue();
        return value != null ? value : Boolean.TRUE;
    }

    @Override
    public boolean isDefaultCacheable() {
        return this.defaultCacheable;
    }

    protected void setDefaultCacheable(boolean cacheable) {
        boolean old = this.defaultCacheable;
        this.defaultCacheable = cacheable;
        this.firePropertyChanged("defaultCacheable", old, cacheable);
    }

    protected boolean buildDefaultCacheable() {
        return this.getCacheableReference().calculateDefaultCacheable();
    }

    protected CacheableAnnotation2_0 getCacheableAnnotation() {
        return (CacheableAnnotation2_0)this.getJavaResourceType().getAnnotation(this.getCacheableAnnotationName());
    }

    protected CacheableAnnotation2_0 getCacheableAnnotationForUpdate() {
        CacheableAnnotation2_0 annotation = this.getCacheableAnnotation();
        return annotation != null ? annotation : this.buildCacheableAnnotation();
    }

    protected CacheableAnnotation2_0 buildCacheableAnnotation() {
        return (CacheableAnnotation2_0)this.getJavaResourceType().addAnnotation(this.getCacheableAnnotationName());
    }

    protected void removeCacheableAnnotation() {
        this.getJavaResourceType().removeAnnotation(this.getCacheableAnnotationName());
    }

    protected String getCacheableAnnotationName() {
        return "javax.persistence.Cacheable";
    }

    protected JavaCacheableReference2_0 getCacheableReference() {
        return (JavaCacheableReference2_0)this.parent;
    }

    protected JavaResourceType getJavaResourceType() {
        return this.getCacheableReference().getJavaResourceType();
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getAnnotationTextRange();
        return textRange != null ? textRange : this.getCacheableReference().getValidationTextRange();
    }

    protected TextRange getAnnotationTextRange() {
        CacheableAnnotation2_0 annotation = this.getCacheableAnnotation();
        return annotation == null ? null : annotation.getTextRange();
    }
}

