/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.internal;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.ExactNumericDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.NumericalDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PrimitiveType;
import org.eclipse.jpt.common.utility.JavaType;
import org.eclipse.jpt.common.utility.internal.SimpleJavaType;
import org.eclipse.jpt.common.utility.internal.TypeDeclarationTools;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.internal.DTPDatabaseObjectWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPTableWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DTPColumnWrapper
extends DTPDatabaseObjectWrapper<DTPTableWrapper, org.eclipse.datatools.modelbase.sql.tables.Column>
implements Column {
    private static final JavaType DEFAULT_JAVA_TYPE = new SimpleJavaType(Object.class);
    private static final JavaType BLOB_JAVA_TYPE = new SimpleJavaType(Blob.class);
    private static final JavaType BYTE_ARRAY_JAVA_TYPE = new SimpleJavaType(byte[].class);
    private static final JavaType CLOB_JAVA_TYPE = new SimpleJavaType(Clob.class);
    private static final JavaType STRING_JAVA_TYPE = new SimpleJavaType(String.class);
    private static final JavaType UTIL_DATE_JAVA_TYPE = new SimpleJavaType(java.util.Date.class);
    private static final JavaType SQL_DATE_JAVA_TYPE = new SimpleJavaType(Date.class);
    private static final JavaType SQL_TIME_JAVA_TYPE = new SimpleJavaType(Time.class);
    private static final JavaType SQL_TIMESTAMP_JAVA_TYPE = new SimpleJavaType(Timestamp.class);
    private static final JavaType BIG_DECIMAL_JAVA_TYPE = new SimpleJavaType(BigDecimal.class);
    private static final JavaType LONG_JAVA_TYPE = new SimpleJavaType(Long.TYPE);

    DTPColumnWrapper(DTPTableWrapper table, org.eclipse.datatools.modelbase.sql.tables.Column dtpColumn) {
        super(table, dtpColumn);
    }

    @Override
    synchronized void catalogObjectChanged() {
        super.catalogObjectChanged();
        this.getConnectionProfile().columnChanged(this);
    }

    @Override
    public DTPTableWrapper getTable() {
        return (DTPTableWrapper)this.parent;
    }

    @Override
    public boolean isPartOfPrimaryKey() {
        return this.getTable().primaryKeyColumnsContains(this);
    }

    @Override
    public boolean isPartOfForeignKey() {
        return this.getTable().foreignKeyBaseColumnsContains(this);
    }

    @Override
    public boolean isPartOfUniqueConstraint() {
        return ((org.eclipse.datatools.modelbase.sql.tables.Column)this.dtpObject).isPartOfUniqueConstraint();
    }

    @Override
    public boolean isNullable() {
        return ((org.eclipse.datatools.modelbase.sql.tables.Column)this.dtpObject).isNullable();
    }

    @Override
    public String getDataTypeName() {
        DataType dataType = ((org.eclipse.datatools.modelbase.sql.tables.Column)this.dtpObject).getDataType();
        return dataType == null ? null : dataType.getName();
    }

    @Override
    public boolean isNumeric() {
        return ((org.eclipse.datatools.modelbase.sql.tables.Column)this.dtpObject).getDataType() instanceof NumericalDataType;
    }

    @Override
    public int getPrecision() {
        DataType dataType = ((org.eclipse.datatools.modelbase.sql.tables.Column)this.dtpObject).getDataType();
        return dataType instanceof NumericalDataType ? ((NumericalDataType)dataType).getPrecision() : -1;
    }

    @Override
    public int getScale() {
        DataType dataType = ((org.eclipse.datatools.modelbase.sql.tables.Column)this.dtpObject).getDataType();
        return dataType instanceof ExactNumericDataType ? ((ExactNumericDataType)dataType).getScale() : -1;
    }

    @Override
    public int getLength() {
        DataType dataType = ((org.eclipse.datatools.modelbase.sql.tables.Column)this.dtpObject).getDataType();
        return dataType instanceof CharacterStringDataType ? ((CharacterStringDataType)dataType).getLength() : -1;
    }

    @Override
    public boolean isLOB() {
        DataType dataType = ((org.eclipse.datatools.modelbase.sql.tables.Column)this.dtpObject).getDataType();
        return dataType instanceof PredefinedDataType ? DTPColumnWrapper.primitiveTypeIsLob(((PredefinedDataType)dataType).getPrimitiveType()) : false;
    }

    @Override
    public String getJavaTypeDeclaration() {
        return this.getJavaType().declaration();
    }

    @Override
    public JavaType getJavaType() {
        DataType dataType = ((org.eclipse.datatools.modelbase.sql.tables.Column)this.dtpObject).getDataType();
        return dataType instanceof PredefinedDataType ? DTPColumnWrapper.convertToJPAJavaType(this.getJavaType((PredefinedDataType)dataType)) : DEFAULT_JAVA_TYPE;
    }

    @Override
    public String getPrimaryKeyJavaTypeDeclaration() {
        return this.getPrimaryKeyJavaType().declaration();
    }

    @Override
    public JavaType getPrimaryKeyJavaType() {
        return DTPColumnWrapper.convertToJPAPrimaryKeyJavaType(this.getJavaType());
    }

    private JavaType getJavaType(PredefinedDataType dataType) {
        String dtpJavaClassName = this.resolveDefinition(dataType).getJavaClassName();
        return new SimpleJavaType(TypeDeclarationTools.className((String)dtpJavaClassName));
    }

    private PredefinedDataTypeDefinition resolveDefinition(PredefinedDataType dataType) {
        return this.getDatabase().getDTPDefinition().getPredefinedDataTypeDefinition(dataType.getName());
    }

    boolean wraps(org.eclipse.datatools.modelbase.sql.tables.Column column) {
        return this.dtpObject == column;
    }

    @Override
    void clear() {
    }

    private static JavaType convertToJPAJavaType(JavaType javaType) {
        if (javaType.equals(BLOB_JAVA_TYPE)) {
            return BYTE_ARRAY_JAVA_TYPE;
        }
        if (javaType.equals(CLOB_JAVA_TYPE)) {
            return STRING_JAVA_TYPE;
        }
        return javaType;
    }

    private static JavaType convertToJPAPrimaryKeyJavaType(JavaType javaType) {
        if (javaType.isVariablePrimitive() || javaType.isVariablePrimitiveWrapper() || javaType.equals(STRING_JAVA_TYPE) || javaType.equals(UTIL_DATE_JAVA_TYPE) || javaType.equals(SQL_DATE_JAVA_TYPE)) {
            return javaType;
        }
        if (javaType.equals(BIG_DECIMAL_JAVA_TYPE)) {
            return LONG_JAVA_TYPE;
        }
        if (javaType.equals(SQL_TIME_JAVA_TYPE)) {
            return UTIL_DATE_JAVA_TYPE;
        }
        if (javaType.equals(SQL_TIMESTAMP_JAVA_TYPE)) {
            return UTIL_DATE_JAVA_TYPE;
        }
        return STRING_JAVA_TYPE;
    }

    private static boolean primitiveTypeIsLob(PrimitiveType primitiveType) {
        return primitiveType == PrimitiveType.BINARY_LARGE_OBJECT_LITERAL || primitiveType == PrimitiveType.CHARACTER_LARGE_OBJECT_LITERAL || primitiveType == PrimitiveType.NATIONAL_CHARACTER_LARGE_OBJECT_LITERAL;
    }
}

