/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.details;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.swt.bind.SWTBindTools;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.iterable.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverterContainer;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCustomConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkStructConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.details.EclipseLinkConverterDialog;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.details.EclipseLinkCustomConverterComposite;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.details.EclipseLinkObjectTypeConverterComposite;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.details.EclipseLinkStructConverterComposite;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.details.EclipseLinkTypeConverterComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkConvertersComposite
extends Pane<EclipseLinkConverterContainer> {
    private EclipseLinkCustomConverterComposite converterComposite;
    private EclipseLinkObjectTypeConverterComposite objectTypeConverterComposite;
    private EclipseLinkStructConverterComposite structConverterComposite;
    private EclipseLinkTypeConverterComposite typeConverterComposite;
    private ModifiableCollectionValueModel<EclipseLinkConverter> selectedConvertersModel;
    private PropertyValueModel<EclipseLinkConverter> selectedConverterModel;

    public EclipseLinkConvertersComposite(Pane<?> parentPane, PropertyValueModel<? extends EclipseLinkConverterContainer> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    protected void initialize() {
        super.initialize();
        this.selectedConvertersModel = this.buildSelectedConvertersModel();
        this.selectedConverterModel = this.buildSelectedConverterModel(this.selectedConvertersModel);
    }

    private ModifiableCollectionValueModel<EclipseLinkConverter> buildSelectedConvertersModel() {
        return new SimpleCollectionValueModel();
    }

    protected PropertyValueModel<EclipseLinkConverter> buildSelectedConverterModel(ModifiableCollectionValueModel<EclipseLinkConverter> selectedConvertersModel) {
        return new CollectionPropertyValueModelAdapter<EclipseLinkConverter, EclipseLinkConverter>(selectedConvertersModel){

            protected EclipseLinkConverter buildValue() {
                if (this.collectionModel.size() == 1) {
                    return (EclipseLinkConverter)this.collectionModel.iterator().next();
                }
                return null;
            }
        };
    }

    protected void initializeLayout(Composite container) {
        this.addListPane(container);
        PageBook pageBook = new PageBook(container, 0);
        pageBook.setLayoutData((Object)new GridData(768));
        this.installPaneSwitcher(pageBook);
    }

    protected EclipseLinkCustomConverterComposite getCustomConverterComposite(PageBook pageBook) {
        if (this.converterComposite == null) {
            this.converterComposite = new EclipseLinkCustomConverterComposite(this, this.buildSelectedCustomConverterModel(), (Composite)pageBook);
        }
        return this.converterComposite;
    }

    protected EclipseLinkObjectTypeConverterComposite getObjectTypeConverterComposite(PageBook pageBook) {
        if (this.objectTypeConverterComposite == null) {
            this.objectTypeConverterComposite = new EclipseLinkObjectTypeConverterComposite(this, this.buildSelectedObjectTypeConverterModel(), (Composite)pageBook);
        }
        return this.objectTypeConverterComposite;
    }

    protected EclipseLinkStructConverterComposite getStructConverterComposite(PageBook pageBook) {
        if (this.structConverterComposite == null) {
            this.structConverterComposite = new EclipseLinkStructConverterComposite(this, this.buildSelectedStructConverterModel(), (Composite)pageBook);
        }
        return this.structConverterComposite;
    }

    protected EclipseLinkTypeConverterComposite getTypeConverterComposite(PageBook pageBook) {
        if (this.typeConverterComposite == null) {
            this.typeConverterComposite = new EclipseLinkTypeConverterComposite(this, this.buildSelectedTypeConverterModel(), (Composite)pageBook);
        }
        return this.typeConverterComposite;
    }

    private AddRemoveListPane<EclipseLinkConverterContainer, EclipseLinkConverter> addListPane(Composite container) {
        return new AddRemoveListPane((Pane)this, container, this.buildConvertersAdapter(), this.buildDisplayableConvertersListHolder(), this.selectedConvertersModel, this.buildConvertersListLabelProvider(), null);
    }

    private void installPaneSwitcher(PageBook pageBook) {
        SWTBindTools.bind(this.selectedConverterModel, this.buildPaneTransformer(pageBook), (PageBook)pageBook);
    }

    private AddRemovePane.Adapter<EclipseLinkConverter> buildConvertersAdapter() {
        return new AddRemovePane.AbstractAdapter<EclipseLinkConverter>(){

            public EclipseLinkConverter addNewItem() {
                return EclipseLinkConvertersComposite.this.addConverter();
            }

            public PropertyValueModel<Boolean> buildRemoveButtonEnabledModel(CollectionValueModel<EclipseLinkConverter> selectedItemsModel) {
                return this.buildSingleSelectedItemEnabledModel(selectedItemsModel);
            }

            public void removeSelectedItems(CollectionValueModel<EclipseLinkConverter> selectedItemsModel) {
                EclipseLinkConverter item = (EclipseLinkConverter)selectedItemsModel.iterator().next();
                if (item.getType() == EclipseLinkCustomConverter.class) {
                    ((EclipseLinkConverterContainer)EclipseLinkConvertersComposite.this.getSubject()).removeCustomConverter((EclipseLinkCustomConverter)item);
                } else if (item.getType() == EclipseLinkObjectTypeConverter.class) {
                    ((EclipseLinkConverterContainer)EclipseLinkConvertersComposite.this.getSubject()).removeObjectTypeConverter((EclipseLinkObjectTypeConverter)item);
                } else if (item.getType() == EclipseLinkStructConverter.class) {
                    ((EclipseLinkConverterContainer)EclipseLinkConvertersComposite.this.getSubject()).removeStructConverter((EclipseLinkStructConverter)item);
                } else if (item.getType() == EclipseLinkTypeConverter.class) {
                    ((EclipseLinkConverterContainer)EclipseLinkConvertersComposite.this.getSubject()).removeTypeConverter((EclipseLinkTypeConverter)item);
                }
            }
        };
    }

    private EclipseLinkConverter addConverter() {
        return this.addEclipseLinkConverterFromDialog(this.buildEclipseLinkConverterDialog());
    }

    protected EclipseLinkConverterDialog buildEclipseLinkConverterDialog() {
        return new EclipseLinkConverterDialog(this.getShell(), this.getResourceManager(), (EclipseLinkConverterContainer)this.getSubject());
    }

    protected EclipseLinkConverter addEclipseLinkConverterFromDialog(EclipseLinkConverterDialog dialog) {
        EclipseLinkCustomConverter converter;
        if (dialog.open() != 0) {
            return null;
        }
        Class<? extends EclipseLinkConverter> converterType = dialog.getConverterType();
        String converterName = dialog.getName();
        if (converterType == EclipseLinkCustomConverter.class) {
            converter = ((EclipseLinkConverterContainer)this.getSubject()).addCustomConverter(converterName, ((EclipseLinkConverterContainer)this.getSubject()).getCustomConvertersSize());
        } else if (converterType == EclipseLinkObjectTypeConverter.class) {
            converter = ((EclipseLinkConverterContainer)this.getSubject()).addObjectTypeConverter(converterName, ((EclipseLinkConverterContainer)this.getSubject()).getObjectTypeConvertersSize());
        } else if (converterType == EclipseLinkStructConverter.class) {
            converter = ((EclipseLinkConverterContainer)this.getSubject()).addStructConverter(converterName, ((EclipseLinkConverterContainer)this.getSubject()).getStructConvertersSize());
        } else if (converterType == EclipseLinkTypeConverter.class) {
            converter = ((EclipseLinkConverterContainer)this.getSubject()).addTypeConverter(converterName, ((EclipseLinkConverterContainer)this.getSubject()).getTypeConvertersSize());
        } else {
            throw new IllegalArgumentException();
        }
        return converter;
    }

    private Transformer<EclipseLinkConverter, Control> buildPaneTransformer(PageBook pageBook) {
        return new PaneTransformer(pageBook);
    }

    private ListValueModel<EclipseLinkConverter> buildDisplayableConvertersListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildEclipseLinkConvertersHolder(), new String[]{"name"});
    }

    private ListValueModel<EclipseLinkConverter> buildEclipseLinkConvertersHolder() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.buildCustomConvertersListHolder());
        list.add(this.buildObjectTypeConvertersListHolder());
        list.add(this.buildStructConvertersListHolder());
        list.add(this.buildTypeConvertersListHolder());
        return CompositeListValueModel.forModels(list);
    }

    private ListValueModel<EclipseLinkCustomConverter> buildCustomConvertersListHolder() {
        return new ListAspectAdapter<EclipseLinkConverterContainer, EclipseLinkCustomConverter>(this.getSubjectHolder(), new String[]{"customConverters"}){

            protected ListIterable<EclipseLinkCustomConverter> getListIterable() {
                return new SuperListIterableWrapper(((EclipseLinkConverterContainer)this.subject).getCustomConverters());
            }

            protected int size_() {
                return ((EclipseLinkConverterContainer)this.subject).getCustomConvertersSize();
            }
        };
    }

    private ListValueModel<EclipseLinkObjectTypeConverter> buildObjectTypeConvertersListHolder() {
        return new ListAspectAdapter<EclipseLinkConverterContainer, EclipseLinkObjectTypeConverter>(this.getSubjectHolder(), new String[]{"objectTypeConverters"}){

            protected ListIterable<EclipseLinkObjectTypeConverter> getListIterable() {
                return new SuperListIterableWrapper(((EclipseLinkConverterContainer)this.subject).getObjectTypeConverters());
            }

            protected int size_() {
                return ((EclipseLinkConverterContainer)this.subject).getObjectTypeConvertersSize();
            }
        };
    }

    private ListValueModel<EclipseLinkStructConverter> buildStructConvertersListHolder() {
        return new ListAspectAdapter<EclipseLinkConverterContainer, EclipseLinkStructConverter>(this.getSubjectHolder(), new String[]{"structConverters"}){

            protected ListIterable<EclipseLinkStructConverter> getListIterable() {
                return new SuperListIterableWrapper(((EclipseLinkConverterContainer)this.subject).getStructConverters());
            }

            protected int size_() {
                return ((EclipseLinkConverterContainer)this.subject).getStructConvertersSize();
            }
        };
    }

    private ListValueModel<EclipseLinkTypeConverter> buildTypeConvertersListHolder() {
        return new ListAspectAdapter<EclipseLinkConverterContainer, EclipseLinkTypeConverter>(this.getSubjectHolder(), new String[]{"typeConverters"}){

            protected ListIterable<EclipseLinkTypeConverter> getListIterable() {
                return new SuperListIterableWrapper(((EclipseLinkConverterContainer)this.subject).getTypeConverters());
            }

            protected int size_() {
                return ((EclipseLinkConverterContainer)this.subject).getTypeConvertersSize();
            }
        };
    }

    private PropertyValueModel<EclipseLinkCustomConverter> buildSelectedCustomConverterModel() {
        return new TransformationPropertyValueModel<EclipseLinkConverter, EclipseLinkCustomConverter>(this.selectedConverterModel){

            protected EclipseLinkCustomConverter transform_(EclipseLinkConverter value) {
                return value.getType() == EclipseLinkCustomConverter.class ? (EclipseLinkCustomConverter)value : null;
            }
        };
    }

    private PropertyValueModel<EclipseLinkObjectTypeConverter> buildSelectedObjectTypeConverterModel() {
        return new TransformationPropertyValueModel<EclipseLinkConverter, EclipseLinkObjectTypeConverter>(this.selectedConverterModel){

            protected EclipseLinkObjectTypeConverter transform_(EclipseLinkConverter value) {
                return value.getType() == EclipseLinkObjectTypeConverter.class ? (EclipseLinkObjectTypeConverter)value : null;
            }
        };
    }

    private PropertyValueModel<EclipseLinkStructConverter> buildSelectedStructConverterModel() {
        return new TransformationPropertyValueModel<EclipseLinkConverter, EclipseLinkStructConverter>(this.selectedConverterModel){

            protected EclipseLinkStructConverter transform_(EclipseLinkConverter value) {
                return value.getType() == EclipseLinkStructConverter.class ? (EclipseLinkStructConverter)value : null;
            }
        };
    }

    private PropertyValueModel<EclipseLinkTypeConverter> buildSelectedTypeConverterModel() {
        return new TransformationPropertyValueModel<EclipseLinkConverter, EclipseLinkTypeConverter>(this.selectedConverterModel){

            protected EclipseLinkTypeConverter transform_(EclipseLinkConverter value) {
                return value.getType() == EclipseLinkTypeConverter.class ? (EclipseLinkTypeConverter)value : null;
            }
        };
    }

    private ILabelProvider buildConvertersListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return ((EclipseLinkConverter)element).getName();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PaneTransformer
    extends AbstractTransformer<EclipseLinkConverter, Control> {
        private final PageBook pageBook;

        protected PaneTransformer(PageBook pageBook) {
            this.pageBook = pageBook;
        }

        public Control transform_(EclipseLinkConverter converter) {
            if (converter.getType() == EclipseLinkCustomConverter.class) {
                return EclipseLinkConvertersComposite.this.getCustomConverterComposite(this.pageBook).getControl();
            }
            if (converter.getType() == EclipseLinkObjectTypeConverter.class) {
                return EclipseLinkConvertersComposite.this.getObjectTypeConverterComposite(this.pageBook).getControl();
            }
            if (converter.getType() == EclipseLinkStructConverter.class) {
                return EclipseLinkConvertersComposite.this.getStructConverterComposite(this.pageBook).getControl();
            }
            if (converter.getType() == EclipseLinkTypeConverter.class) {
                return EclipseLinkConvertersComposite.this.getTypeConverterComposite(this.pageBook).getControl();
            }
            return null;
        }
    }
}

