/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.cmd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.jubula.client.cmd.JobConfiguration;
import org.eclipse.jubula.client.cmd.exceptions.PreValidateException;
import org.eclipse.jubula.client.cmd.i18n.Messages;
import org.eclipse.jubula.client.cmd.progess.HeadlessProgressProvider;
import org.eclipse.jubula.client.core.ClientTestFactory;
import org.eclipse.jubula.client.core.communication.AutAgentConnection;
import org.eclipse.jubula.client.core.communication.ConnectionException;
import org.eclipse.jubula.client.core.errorhandling.ErrorMessagePresenter;
import org.eclipse.jubula.client.core.errorhandling.IErrorMessagePresenter;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.persistence.locking.LockManager;
import org.eclipse.jubula.client.core.preferences.database.DatabaseConnection;
import org.eclipse.jubula.client.core.preferences.database.DatabaseConnectionConverter;
import org.eclipse.jubula.client.core.progress.IProgressConsole;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.messagehandling.Message;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.registration.AutIdentifier;
import org.eclipse.jubula.tools.utils.TimeUtil;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCmdlineClient
implements IProgressConsole {
    protected static final int EXIT_CODE_ERROR = 1;
    protected static final int EXIT_CODE_OK = 0;
    protected static final String OPT_NO_VAL = String.valueOf(Messages.NoArgumentFor) + ":";
    protected static final String OPT_UNKNOWN = String.valueOf(Messages.UnrecognizedOption) + ":" + " ";
    protected static final String JDBC_UNKNOWN = String.valueOf(Messages.UnsupportedJDBC) + ":" + " ";
    private static Logger log = LoggerFactory.getLogger(AbstractCmdlineClient.class);
    private static boolean quiet = false;
    private static boolean errorOccured = false;
    private boolean m_noRun = false;
    private CommandLine m_cmd = null;
    private File m_configFile;
    private JobConfiguration m_job;

    protected static Option createOption(String name, boolean hasArg, String argname, String text, boolean isReq) {
        Option opt = new Option(name, hasArg, text);
        opt.setRequired(isReq);
        opt.setArgName(argname);
        return opt;
    }

    protected void shutdown() {
        block10: {
            IAUTConfigPO startedConfig;
            try {
                if (!AutAgentConnection.getInstance().isConnected()) {
                    AbstractCmdlineClient.printlnConsoleError(Messages.ConnectionToAutUnexpectedly);
                }
            }
            catch (ConnectionException e) {
                log.info(Messages.ConnectionToAutUnexpectedly, (Throwable)e);
            }
            if ((startedConfig = this.m_job.getAutConfig()) == null) break block10;
            try {
                AutIdentifier startedAutId = new AutIdentifier((String)startedConfig.getConfigMap().get("AUT_ID"));
                if (AutAgentConnection.getInstance().isConnected()) {
                    ClientTestFactory.getClientTest().stopAut(startedAutId);
                }
            }
            catch (ConnectionException e) {
                log.info(Messages.ErrorWhileShuttingDownStopping, (Throwable)e);
            }
        }
        try {
            while (AutAgentConnection.getInstance().isConnected()) {
                ClientTestFactory.getClientTest().disconnectFromAutAgent();
                TimeUtil.delay((long)200L);
            }
        }
        catch (ConnectionException e) {
            log.info(Messages.ErrorWhileShuttingDownDisconnecting, (Throwable)e);
        }
        if (LockManager.isRunning()) {
            LockManager.instance().dispose();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean parseCommandLine(String[] args) throws FileNotFoundException, ParseException, IOException {
        block13: {
            String[] cloneArgs = (String[])args.clone();
            Options options = this.createOptions(false);
            BasicParser parser = new BasicParser();
            try {
                int maxTrys = 5;
                Boolean parseNotOK = true;
                while (parseNotOK.booleanValue()) {
                    try {
                        this.m_cmd = parser.parse(options, cloneArgs);
                        parseNotOK = false;
                    }
                    catch (ParseException exp) {
                        cloneArgs = this.handleParseException(args, exp);
                        if (maxTrys-- >= 0) continue;
                        throw new ParseException("");
                    }
                }
                if (!this.m_cmd.hasOption("h")) break block13;
                this.printUsage();
                return false;
            }
            catch (PreValidateException exp) {
                String message = exp.getLocalizedMessage();
                if (message != null && message.length() > 0) {
                    AbstractCmdlineClient.printlnConsoleError(message);
                }
                this.printUsage();
                throw new ParseException("");
            }
        }
        if (this.m_cmd.hasOption("c")) {
            this.m_configFile = new File(this.m_cmd.getOptionValue("c"));
            if (!this.m_configFile.exists() || !this.m_configFile.canRead()) throw new FileNotFoundException("");
            AbstractCmdlineClient.printConsoleLn(String.valueOf(Messages.ClientConfigFile) + this.m_configFile.getAbsolutePath(), true);
            this.m_job = JobConfiguration.initJob(this.m_configFile);
        } else {
            this.m_job = JobConfiguration.initJob(null);
        }
        if (this.m_cmd.hasOption("q")) {
            quiet = true;
        }
        if (this.m_cmd.hasOption("n")) {
            this.m_noRun = true;
        }
        if (this.m_cmd.hasOption("startserver")) {
            this.m_job.parseOptionsWithServer(this.m_cmd);
        } else {
            this.m_job.parseJobOptions(this.m_cmd);
        }
        this.preValidate(this.m_job);
        return true;
    }

    private Options createOptions(boolean req) {
        Options options = new Options();
        options.addOption(AbstractCmdlineClient.createOption("h", false, "", Messages.ClientHelpOpt, false));
        options.addOption(AbstractCmdlineClient.createOption("q", false, "", Messages.ClientQuietOpt, false));
        options.addOption(AbstractCmdlineClient.createOption("c", true, "configfile", Messages.ClientConfigOpt, false));
        OptionGroup ogConnection = new OptionGroup();
        ogConnection.addOption(AbstractCmdlineClient.createOption("dburl", true, "database", Messages.ClientDburlOpt, false));
        ogConnection.addOption(AbstractCmdlineClient.createOption("dbscheme", true, "scheme", Messages.ClientDbschemeOpt, false));
        options.addOptionGroup(ogConnection);
        options.addOption(AbstractCmdlineClient.createOption("dbuser", true, "user", Messages.ClientDbuserOpt, false));
        options.addOption(AbstractCmdlineClient.createOption("dbpw", true, "password", Messages.ClientDbpwOpt, false));
        this.extendOptions(options, req);
        return options;
    }

    protected abstract void extendOptions(Options var1, boolean var2);

    protected void preRun() {
    }

    public static void printConsoleLn(String text, boolean printTimestamp) {
        if (printTimestamp) {
            Date now = new Date();
            String time = now.toString();
            AbstractCmdlineClient.printConsole(time);
            AbstractCmdlineClient.printConsole("\t");
        }
        AbstractCmdlineClient.printConsole(StringUtils.chomp((String)text));
        AbstractCmdlineClient.printConsole("\n");
    }

    public void writeErrorLine(String line) {
        AbstractCmdlineClient.printlnConsoleError(line);
    }

    public void writeLine(String line) {
        AbstractCmdlineClient.printConsole(String.valueOf(line) + "\n");
    }

    public static void printConsole(String text) {
        if (!quiet) {
            System.out.print(text);
        }
    }

    public static void printlnConsoleError(String text) {
        errorOccured = true;
        log.error(String.valueOf(Messages.AnErrorOcurred) + ":" + " " + text);
        System.err.println(String.valueOf(Messages.ClientError) + "\n" + "\t" + text);
    }

    public int run(String[] args) {
        Job.getJobManager().setProgressProvider((ProgressProvider)new HeadlessProgressProvider());
        ErrorMessagePresenter.setPresenter((IErrorMessagePresenter)new IErrorMessagePresenter(){

            public void showErrorMessage(JBException ex, Object[] params, String[] details) {
                log.error(ex + ":" + " " + ex.getMessage());
                Integer messageID = ex.getErrorId();
                this.showErrorMessage(messageID, params, details);
            }

            public void showErrorMessage(Integer messageID, Object[] params, String[] details) {
                Message m = MessageIDs.getMessageObject((Integer)messageID);
                if (m == null) {
                    log.error(String.valueOf(Messages.NoCorrespondingMessage) + ":" + " " + messageID);
                } else {
                    String msgString = m.getMessage(params);
                    if (m.getSeverity() == 4) {
                        AbstractCmdlineClient.printlnConsoleError(msgString);
                    } else {
                        AbstractCmdlineClient.printConsole(msgString);
                    }
                }
            }
        });
        try {
            if (!this.parseCommandLine(args)) {
                return 1;
            }
        }
        catch (ParseException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return 1;
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return 1;
        }
        this.preRun();
        try {
            int exitCode = this.doRun();
            if (AbstractCmdlineClient.isErrorOccured()) {
                exitCode = 1;
            }
            AbstractCmdlineClient.printConsoleLn(String.valueOf(Messages.ClientExitCode) + exitCode, true);
            return exitCode;
        }
        catch (Throwable t) {
            log.error(t.getLocalizedMessage(), t);
            AbstractCmdlineClient.printlnConsoleError(t.getLocalizedMessage());
            return 1;
        }
    }

    protected abstract int doRun();

    private void preValidate(JobConfiguration job) throws PreValidateException {
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append(Messages.ClientMissingArgs);
        if (job.getDbConnectionName() == null && job.getDb() == null) {
            this.appendError(errorMsg, "dbscheme", "scheme OR");
            this.appendError(errorMsg, "dburl", "database");
        }
        if (!(job.getDb() == null || job.getDb().startsWith("jdbc:oracle:thin:@") || job.getDb().startsWith("jdbc:mysql://") || job.getDb().startsWith("jdbc:postgresql://") || job.getDb().startsWith("jdbc:h2:"))) {
            this.appendError(errorMsg, JDBC_UNKNOWN, job.getDb());
        }
        if (job.getDbuser() == null) {
            this.appendError(errorMsg, "dbuser", "user");
        }
        if (job.getDbpw() == null) {
            this.appendError(errorMsg, "dbpw", "password");
        }
        this.extendValidate(job, errorMsg);
        if (errorOccured) {
            throw new PreValidateException(errorMsg.toString());
        }
        if (job.getDbscheme() == null && job.getDb() == null) {
            List availableConnections = DatabaseConnectionConverter.computeAvailableConnections();
            ArrayList<String> connectionNames = new ArrayList<String>();
            for (DatabaseConnection conn : availableConnections) {
                connectionNames.add(conn.getName());
            }
            throw new PreValidateException(NLS.bind((String)Messages.NoSuchDatabaseConnection, (Object[])new String[]{job.getDbConnectionName(), StringUtils.join(connectionNames, (String)", ")}));
        }
    }

    protected abstract void extendValidate(JobConfiguration var1, StringBuilder var2);

    public String[] handleParseException(String[] args, ParseException exp) {
        int idx;
        String message = exp.getLocalizedMessage();
        if (message != null && message.length() > 0) {
            AbstractCmdlineClient.printlnConsoleError(message);
        }
        if (message.startsWith(OPT_NO_VAL)) {
            idx = message.indexOf(":");
            message = message.substring(idx + 1);
        } else if (message.startsWith(OPT_UNKNOWN)) {
            idx = message.indexOf(":");
            message = message.substring(idx + 2);
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].endsWith(message)) {
                args[i] = "";
            }
            ++i;
        }
        return args;
    }

    protected void appendError(StringBuilder errorMsg, String msg1, String msg2) {
        errorOccured = true;
        errorMsg.append("\t");
        errorMsg.append("-");
        errorMsg.append(msg1);
        errorMsg.append(" ");
        errorMsg.append(msg2);
        errorMsg.append("\n");
    }

    private void printUsage() {
        Options options = this.createOptions(true);
        options.addOption(AbstractCmdlineClient.createOption("data", true, "workspace_location", Messages.ClientWorkspaceOpt, false));
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.getCmdlineClientExecName(), options, true);
    }

    public abstract String getCmdlineClientExecName();

    public boolean isNoRun() {
        return this.m_noRun;
    }

    public boolean isQuiet() {
        return quiet;
    }

    public static boolean isErrorOccured() {
        return errorOccured;
    }

    public CommandLine getCmdLine() {
        return this.m_cmd;
    }

    public JobConfiguration getJob() {
        return this.m_job;
    }
}

