/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jubula.client.core.businessprocess.IObjectMappingObserver;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;

public class ObjectMappingEventDispatcher {
    private static List<IObjectMappingObserver> observer = new ArrayList<IObjectMappingObserver>();
    private static IObjectMappingPO objMapTransient;
    private static IObjectMappingCategoryPO categoryToCreateIn;

    private ObjectMappingEventDispatcher() {
    }

    public static synchronized void notifyRecordObserver(ISpecTestCasePO tc) {
        List<IObjectMappingObserver> obs = Collections.unmodifiableList(observer);
        if (obs.isEmpty()) {
            return;
        }
        ITestSuitePO[] testSuites = ObjectMappingEventDispatcher.getTestSuitesOfSpecTestCase(tc);
        HashSet<IAUTMainPO> autList = new HashSet<IAUTMainPO>();
        ITestSuitePO[] iTestSuitePOArray = testSuites;
        int n = testSuites.length;
        int n2 = 0;
        while (n2 < n) {
            ITestSuitePO ts = iTestSuitePOArray[n2];
            autList.add(ts.getAut());
            ++n2;
        }
        for (IAUTMainPO aut : autList) {
            for (IObjectMappingObserver obsvr : obs) {
                try {
                    obsvr.update(1, aut);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static void notifyObjectMappedObserver(IComponentIdentifier[] tech) {
        List<IObjectMappingObserver> obs = Collections.unmodifiableList(observer);
        for (IObjectMappingObserver obsvr : obs) {
            try {
                obsvr.update(2, tech);
            }
            catch (Throwable throwable) {}
        }
    }

    private static ITestSuitePO[] getTestSuitesOfSpecTestCase(ISpecTestCasePO specTc) {
        ArrayList<INodePO> testSuiteList = new ArrayList<INodePO>();
        List<IExecTestCasePO> execTestCases = NodePM.getInternalExecTestCases(specTc.getGuid(), specTc.getParentProjectId());
        for (IExecTestCasePO execTc : execTestCases) {
            INodePO execTcParent = execTc.getParentNode();
            if (execTcParent instanceof ITestSuitePO) {
                if (testSuiteList.contains(execTcParent)) continue;
                testSuiteList.add(execTcParent);
                continue;
            }
            if (!(execTcParent instanceof ISpecTestCasePO)) continue;
            testSuiteList.addAll(Arrays.asList(ObjectMappingEventDispatcher.getTestSuitesOfSpecTestCase((ISpecTestCasePO)execTcParent)));
        }
        return testSuiteList.toArray(new ITestSuitePO[testSuiteList.size()]);
    }

    public static void addObserver(IObjectMappingObserver obs) {
        if (!observer.contains(obs)) {
            observer.add(obs);
        }
    }

    public static void removeObserver(IObjectMappingObserver obs) {
        if (observer.contains(obs)) {
            observer.remove(obs);
        }
    }

    public static IObjectMappingPO getObjMapTransient() {
        if (objMapTransient == null) {
            objMapTransient = PoMaker.createObjectMappingPO();
        }
        return objMapTransient;
    }

    public static void clearObjMapTransient() {
        objMapTransient = null;
    }

    public static IObjectMappingCategoryPO getCategoryToCreateIn() {
        return categoryToCreateIn;
    }

    public static void setCategoryToCreateIn(IObjectMappingCategoryPO c) {
        categoryToCreateIn = c;
    }
}

