/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.preferences.database;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.preferences.database.AbstractHostBasedConnectionInfo;

public class OracleConnectionInfo
extends AbstractHostBasedConnectionInfo {
    public static final String DRIVER_CLASS_NAME = "oracle.jdbc.driver.OracleDriver";
    public static final String JDBC_PRE = "jdbc:oracle:thin:@";
    private static final String ORACLE_BATCH_WRITING_SIZE = "1000";

    public OracleConnectionInfo() {
        super(1521);
    }

    public String getConnectionUrl() {
        StringBuilder sb = new StringBuilder(JDBC_PRE);
        sb.append(StringUtils.defaultString((String)this.getHostname())).append(":").append(this.getPort()).append(":").append(StringUtils.defaultString((String)this.getDatabaseName()));
        return sb.toString();
    }

    public String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    public String getBatchWriting() {
        return "Oracle-JDBC";
    }

    public String getBatchWritingSize() {
        return ORACLE_BATCH_WRITING_SIZE;
    }

    public String getStatisticsCommand() {
        return "begin\nfor tab in (\nselect * from USER_TABLES tab order by TAB.TABLE_NAME\n) loop\nexecute immediate 'analyze table ' || TAB.TABLE_NAME || ' compute statistics';\nend loop;\nend;\n";
    }
}

