/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.propertytester;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICompIdentifierPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.propertytester.AbstractBooleanPropertyTester;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentNameCollectionPropertyTester
extends AbstractBooleanPropertyTester {
    public static final String ARE_SAME_TYPE_PROP = "areSameType";
    public static final String ARE_SAME_TECH_PROP = "areSameTech";
    public static final String ARE_IN_CURRENT_PROJECT = "areInCurrentProject";
    private static final String[] PROPERTIES = new String[]{"areInCurrentProject", "areSameTech", "areSameType"};
    private static final Logger LOG = LoggerFactory.getLogger(ComponentNameCollectionPropertyTester.class);

    public boolean testImpl(Object receiver, String property, Object[] args) {
        Collection collection = (Collection)receiver;
        ArrayList<IComponentNamePO> compNames = new ArrayList<IComponentNamePO>();
        for (Object element : collection) {
            if (element instanceof IComponentNamePO) {
                compNames.add((IComponentNamePO)element);
                continue;
            }
            LOG.warn(NLS.bind((String)Messages.PropertyTesterTypeNotSupported, (Object)element.getClass().getName()));
            return false;
        }
        if (property.equals(ARE_SAME_TYPE_PROP)) {
            return this.testAreSameType(compNames);
        }
        if (property.equals(ARE_SAME_TECH_PROP)) {
            return this.testAreMappedToSameTechnicalNames(compNames);
        }
        if (property.equals(ARE_IN_CURRENT_PROJECT)) {
            return this.testAreInCurrentProject(compNames);
        }
        return false;
    }

    private boolean testAreSameType(Collection<IComponentNamePO> compNames) {
        String type = null;
        for (IComponentNamePO compName : compNames) {
            if (type == null) {
                type = compName.getComponentType();
                continue;
            }
            if (type.equals(compName.getComponentType())) continue;
            return false;
        }
        return true;
    }

    private boolean testAreMappedToSameTechnicalNames(Collection<IComponentNamePO> compNames) {
        for (IAUTMainPO aut : this.getAuts()) {
            ICompIdentifierPO technicalName = null;
            for (IComponentNamePO compName : compNames) {
                for (IObjectMappingAssoziationPO assoc : aut.getObjMap().getMappings()) {
                    if (!assoc.getLogicalNames().contains(compName.getGuid())) continue;
                    if (technicalName == null) {
                        technicalName = assoc.getTechnicalName();
                        continue;
                    }
                    if (assoc.getTechnicalName() == null || assoc.getTechnicalName().equals(technicalName)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean testAreInCurrentProject(Collection<IComponentNamePO> compNames) {
        IProjectPO currentProject = GeneralStorage.getInstance().getProject();
        if (currentProject != null) {
            Long projectId = currentProject.getId();
            for (IComponentNamePO compName : compNames) {
                if (projectId.equals(compName.getParentProjectId())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Set<IAUTMainPO> getAuts() {
        IProjectPO currentProject;
        HashSet<IAUTMainPO> returnSet = new HashSet<IAUTMainPO>();
        IWorkbenchPart activeEditor = Plugin.getActivePart();
        if (activeEditor instanceof ObjectMappingMultiPageEditor) {
            ObjectMappingMultiPageEditor omEditor = (ObjectMappingMultiPageEditor)activeEditor;
            returnSet.add(omEditor.getAut());
        }
        if ((currentProject = GeneralStorage.getInstance().getProject()) != null) {
            returnSet.addAll(currentProject.getAutMainList());
        }
        return returnSet;
    }

    public Class<? extends Object> getType() {
        return Collection.class;
    }

    public String[] getProperties() {
        return PROPERTIES;
    }
}

