/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.propertytester;

import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.propertytester.AbstractBooleanPropertyTester;
import org.eclipse.jubula.client.ui.rcp.search.result.BasicSearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchTestCasePropertyTester
extends AbstractBooleanPropertyTester {
    public static final String IS_EXEC = "isExec";
    public static final String IS_EXEC_OR_SPEC_AND_USES_CTDS = "isExecOrSpecAndUsesCTDS";
    private static final String[] PROPERTIES = new String[]{"isExec", "isExecOrSpecAndUsesCTDS"};

    public boolean testImpl(Object receiver, String property, Object[] args) {
        if (receiver instanceof BasicSearchResult.SearchResultElement) {
            BasicSearchResult.SearchResultElement searchResult = (BasicSearchResult.SearchResultElement)receiver;
            IProjectPO project = GeneralStorage.getInstance().getProject();
            if (project != null && !project.getIsProtected()) {
                try {
                    INodePO node = (INodePO)GeneralStorage.getInstance().getMasterSession().find(NodeMaker.getTestCasePOClass(), searchResult.getData());
                    if (node != null) {
                        return SearchTestCasePropertyTester.isValidNode(property, node);
                    }
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        return false;
    }

    private static boolean isValidNode(String property, INodePO node) {
        ITestCasePO testCase;
        if (property.equals(IS_EXEC)) {
            return SearchTestCasePropertyTester.isExistingTestCase(node);
        }
        if (property.equals(IS_EXEC_OR_SPEC_AND_USES_CTDS) && node instanceof ITestCasePO && (testCase = (ITestCasePO)node).getReferencedDataCube() != null) {
            return SearchTestCasePropertyTester.isExistingTestCase((INodePO)testCase);
        }
        return false;
    }

    private static boolean isExistingTestCase(INodePO node) {
        if (node instanceof IExecTestCasePO) {
            IExecTestCasePO exec = (IExecTestCasePO)node;
            return exec.getSpecTestCase() != null;
        }
        return node instanceof ISpecTestCasePO;
    }

    public Class<? extends Object> getType() {
        return BasicSearchResult.SearchResultElement.class;
    }

    public String[] getProperties() {
        return PROPERTIES;
    }
}

