/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.rcp.installer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jubula.rc.rcp.installer.BundleIterator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class BundleInstaller
implements BundleActivator {
    private static final String E4_SPECIFIC_BUNDLE = "org.eclipse.e4.core.services";
    private static final String SWT_SPECIFIC_BUNDLE = "org.eclipse.swt";
    private static final String BUNDLE_FOLDER_SUFFIX_SWT = ".swt";
    private static final String BUNDLE_FOLDER_SUFFIX_E3 = ".e3";
    private static final String BUNDLE_FOLDER_SUFFIX_E4 = ".e4";
    private static final String BUNDLE_FOLDER_SUFFIX_E4_SWT = ".e4.swt";

    public void start(BundleContext context) throws Exception {
        List bundleFolderSuffixes = BundleInstaller.getBundleFolderSuffixes(context);
        try {
            List installedBundles = BundleInstaller.installAllBundles(context, bundleFolderSuffixes);
            BundleInstaller.startBundles(installedBundles);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static List getBundleFolderSuffixes(BundleContext context) {
        ArrayList<String> bundleFolderSuffixes = new ArrayList<String>();
        bundleFolderSuffixes.add("");
        Bundle[] installedBundles = context.getBundles();
        if (BundleInstaller.isBundleInstalled(installedBundles, E4_SPECIFIC_BUNDLE)) {
            bundleFolderSuffixes.add(BUNDLE_FOLDER_SUFFIX_E4);
            if (BundleInstaller.isBundleInstalled(installedBundles, SWT_SPECIFIC_BUNDLE)) {
                bundleFolderSuffixes.add(BUNDLE_FOLDER_SUFFIX_SWT);
                bundleFolderSuffixes.add(BUNDLE_FOLDER_SUFFIX_E4_SWT);
            }
        } else {
            bundleFolderSuffixes.add(BUNDLE_FOLDER_SUFFIX_SWT);
            bundleFolderSuffixes.add(BUNDLE_FOLDER_SUFFIX_E3);
        }
        return bundleFolderSuffixes;
    }

    private static boolean isBundleInstalled(Bundle[] installedBundles, String bundleName) {
        int i = 0;
        while (i < installedBundles.length) {
            if (bundleName.compareTo(installedBundles[i].getSymbolicName()) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static List installAllBundles(BundleContext context, List bundleFolderSuffixes) throws BundleException, IOException {
        ArrayList bundles = new ArrayList();
        Iterator suffixes = bundleFolderSuffixes.iterator();
        while (suffixes.hasNext()) {
            bundles.addAll(BundleInstaller.installBundlesWithSuffix(context, (String)suffixes.next()));
        }
        return bundles;
    }

    private static List installBundlesWithSuffix(BundleContext context, String suffix) throws IOException, BundleException, SecurityException, IllegalArgumentException {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        BundleIterator it = new BundleIterator(context, suffix);
        while (it.hasNext()) {
            it.next();
            Bundle newBundle = it.installBundle();
            if (newBundle == null) continue;
            bundles.add(newBundle);
        }
        return bundles;
    }

    private static void startBundles(List bundles) throws BundleException {
        Iterator it = bundles.iterator();
        while (it.hasNext()) {
            Bundle bundle = (Bundle)it.next();
            bundle.start();
        }
    }

    public void stop(BundleContext context) throws Exception {
        BundleInstaller.stopAllBundles(context, BundleInstaller.getBundleFolderSuffixes(context));
    }

    private static void stopAllBundles(BundleContext context, List bundleFolderSuffixes) {
        Iterator itSuffixes = bundleFolderSuffixes.iterator();
        while (itSuffixes.hasNext()) {
            BundleIterator it = new BundleIterator(context, (String)itSuffixes.next());
            while (it.hasNext()) {
                it.next();
                try {
                    it.uninstallBundle();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

