/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.i18n;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompSystemI18n {
    private static Logger log;
    private static final List PLUGIN_BUNDLES;
    private static final Map I18N_MAP;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.tools.i18n.CompSystemI18n");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        PLUGIN_BUNDLES = new LinkedList();
        I18N_MAP = new HashMap();
    }

    private CompSystemI18n() {
    }

    public static void addResourceBundle(ResourceBundle bundle) {
        if (bundle == null) {
            log.error("ResourceBundle is null!");
            return;
        }
        PLUGIN_BUNDLES.add(bundle);
    }

    public static String getString(String key) {
        return CompSystemI18n.getString(key, false);
    }

    public static String getString(String key, boolean fallBack) {
        try {
            return CompSystemI18n.getStringInternal(key);
        }
        catch (MissingResourceException mre) {
            if (!fallBack) {
                CompSystemI18n.logError(key, mre);
            }
            return key;
        }
    }

    private static void logError(String key, Throwable throwable) {
        log.error("Cannot find I18N-key in resource bundles: " + key, throwable);
    }

    private static String getStringInternal(String key) {
        if (key == null) {
            return "";
        }
        String value = (String)I18N_MAP.get(key);
        if (value != null) {
            return value;
        }
        Iterator bundleIter = PLUGIN_BUNDLES.iterator();
        while (bundleIter.hasNext()) {
            ResourceBundle bundle = (ResourceBundle)bundleIter.next();
            try {
                value = bundle.getString(key);
                I18N_MAP.put(key, value);
                return value;
            }
            catch (MissingResourceException missingResourceException) {}
        }
        I18N_MAP.put(key, key);
        String string = "No entry found for key: " + key;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.tools.i18n.CompSystemI18n");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        throw new MissingResourceException(string, clazz.getName(), key);
    }

    /*
     * Unable to fully structure code
     */
    public static String getString(String key, Object[] args) {
        try {
            formatter = new MessageFormat(CompSystemI18n.getStringInternal(key));
            return formatter.format(args);
        }
        catch (MissingResourceException e) {
            CompSystemI18n.logError(key, e);
            buf = new StringBuffer(key);
            i = 0;
            ** while (i < args.length)
        }
lbl-1000:
        // 1 sources

        {
            if (args[i] != null) {
                buf.append(" ");
                buf.append(args[i]);
            }
            ++i;
            continue;
        }
lbl16:
        // 1 sources

        return buf.toString();
    }

    public static void setLanguage(String lang) {
        Locale.setDefault(new Locale(lang, ""));
    }

    public static String bundlesToString() {
        StringBuffer entries = new StringBuffer();
        Iterator bundlesIt = PLUGIN_BUNDLES.iterator();
        while (bundlesIt.hasNext()) {
            ResourceBundle bundle = (ResourceBundle)bundlesIt.next();
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = String.valueOf(keys.nextElement());
                String value = bundle.getString(key);
                entries.append(key).append("=").append(value).append("\n");
            }
        }
        return entries.toString();
    }

    public static void fromString(String string) {
        ByteArrayInputStream stream = new ByteArrayInputStream(string.getBytes());
        try {
            PropertyResourceBundle bundle = new PropertyResourceBundle(stream);
            PLUGIN_BUNDLES.clear();
            CompSystemI18n.addResourceBundle(bundle);
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

