/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.serialisation;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.BaseException;
import com.thoughtworks.xstream.core.util.CompositeClassLoader;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.tools.exception.SerialisationException;
import org.eclipse.jubula.tools.jarutils.IVersion;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.serialisation.IXmlSerializer;

public class XStreamXmlSerializer
implements IXmlSerializer {
    private static final String XML_HEADER = "<?xml version=\"1.0\" minor=\"" + IVersion.JB_XML_IMPORT_MINOR_VERSION + "\" major=\"" + IVersion.JB_XML_IMPORT_MAJOR_VERSION + "\"?>";
    private final XStream m_stream = new XStream((ReflectionProvider)new PureJavaReflectionProvider(), (HierarchicalStreamDriver)new DomDriver());
    private final List m_addedClassLoaders = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deserialize(String text, Class clazz) throws SerialisationException {
        Validate.notNull((Object)text);
        Validate.notNull((Object)clazz);
        try {
            ClassLoader streamClassLoader = this.m_stream.getClassLoader();
            if (streamClassLoader instanceof CompositeClassLoader) {
                XStreamXmlSerializer xStreamXmlSerializer = this;
                synchronized (xStreamXmlSerializer) {
                    ClassLoader classLoader = clazz.getClassLoader();
                    if (!this.m_addedClassLoaders.contains(classLoader)) {
                        ((CompositeClassLoader)streamClassLoader).add(classLoader);
                        this.m_addedClassLoaders.add(classLoader);
                    }
                }
            }
            if (text.startsWith("<?")) {
                String xmlHeader = text.substring(0, text.indexOf(">") + 1);
                String xmlBody = StringUtils.substringAfter((String)text, (String)">");
                this.checkVersion(xmlHeader);
                return this.m_stream.fromXML(xmlBody);
            }
            return this.m_stream.fromXML(text);
        }
        catch (BaseException e) {
            throw new SerialisationException(e.getMessage(), MessageIDs.E_SERILIZATION_FAILED);
        }
    }

    private void checkVersion(String header) {
        if (header.indexOf("minor") == -1 || header.indexOf("major") == -1) {
            return;
        }
        String minor = header.substring(header.indexOf("minor"), header.indexOf("major"));
        String major = header.substring(header.indexOf("major"));
        StringUtils.substringBetween((String)minor, (String)"\"");
        StringUtils.substringBetween((String)major, (String)"\"");
    }

    public String serialize(Object object, boolean writeXmlHeader) throws SerialisationException {
        Validate.notNull((Object)object);
        try {
            StringBuffer buffer = new StringBuffer();
            if (writeXmlHeader) {
                buffer.append(XML_HEADER);
            }
            buffer.append(this.m_stream.toXML(object));
            return buffer.toString();
        }
        catch (BaseException e) {
            throw new SerialisationException(e.getMessage(), MessageIDs.E_SERILIZATION_FAILED);
        }
    }

    public Object getImplementation() {
        return this.m_stream;
    }
}

