/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.utils;

import java.util.Date;
import org.eclipse.jubula.tools.utils.EnvironmentUtils;

public abstract class TimeUtil {
    private TimeUtil() {
    }

    public static void delay(long delayInMs) {
        if (delayInMs == 0L) {
            return;
        }
        if (delayInMs < 0L) {
            throw new IllegalArgumentException("delay has to be positive");
        }
        long endTime = new Date().getTime() + delayInMs;
        long delay = delayInMs;
        do {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {}
        } while ((delay = endTime - new Date().getTime()) > 0L);
    }

    public static void delayDefaultOrExternalTime(long defaultDelay, String delayPropertyKey) {
        long timeToWait = defaultDelay;
        try {
            String value = EnvironmentUtils.getProcessOrSystemProperty(delayPropertyKey);
            timeToWait = Long.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {}
        TimeUtil.delay(timeToWait);
    }

    public static String getDurationString(Date startTime, Date endTime) {
        long minutes;
        long seconds;
        long timeInSeconds = endTime.getTime() - startTime.getTime();
        long hours = (timeInSeconds /= 1000L) / 3600L;
        timeInSeconds -= hours * 3600L;
        String secondsString = (seconds = (timeInSeconds -= (minutes = timeInSeconds / 60L) * 60L)) < 10L ? "0" + seconds : String.valueOf(seconds);
        String minutesString = minutes < 10L ? "0" + minutes : String.valueOf(minutes);
        String hoursString = hours < 10L ? "0" + hours : String.valueOf(hours);
        return String.valueOf(hoursString) + ":" + minutesString + ":" + secondsString;
    }
}

