/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.debug.core.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.dltk.dbgp.DbgpBaseCommands;
import org.eclipse.dltk.dbgp.DbgpRequest;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.IDbgpService;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugTarget;
import org.eclipse.koneki.ldt.debug.core.internal.Activator;
import org.eclipse.koneki.ldt.debug.core.internal.LuaCoroutine;
import org.eclipse.koneki.ldt.debug.core.internal.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LuaDebugTarget
extends ScriptDebugTarget {
    private List<LuaCoroutine> coroutines = new ArrayList<LuaCoroutine>();

    public LuaDebugTarget(String modelId, IDbgpService dbgpService, String sessionId, ILaunch launch, IProcess process) {
        super(modelId, dbgpService, sessionId, launch, process);
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            protected List<LuaCoroutine> parseCoroutineList(Element response) throws DbgpException, CoreException {
                NodeList xmlNodes = response.getElementsByTagName("coroutine");
                ArrayList<LuaCoroutine> coroList = new ArrayList<LuaCoroutine>(xmlNodes.getLength());
                int i = 0;
                while (i < xmlNodes.getLength()) {
                    Element coro = (Element)xmlNodes.item(i);
                    if (coro.getAttribute("running").equals("0")) {
                        coroList.add(new LuaCoroutine(LuaDebugTarget.this, coro.getAttribute("id"), coro.getAttribute("name")));
                    }
                    ++i;
                }
                return coroList;
            }

            public void handleDebugEvents(DebugEvent[] events) {
                DebugEvent[] debugEventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugEvent event = debugEventArray[n2];
                    if (event.getKind() == 2) {
                        IScriptThread thread = (IScriptThread)event.getSource();
                        DbgpRequest listRequest = DbgpBaseCommands.createRequest((String)"coroutine_list");
                        try {
                            Element response = thread.getDbgpSession().getCommunicator().communicate(listRequest);
                            LuaDebugTarget.this.coroutines = this.parseCoroutineList(response);
                        }
                        catch (DbgpException e) {
                            Activator.logError(Messages.LuaDebugTarget_error_coro_list, e);
                            LuaDebugTarget.this.coroutines.clear();
                        }
                        catch (CoreException e) {
                            Activator.logError(Messages.LuaDebugTarget_error_coro_list, e);
                            LuaDebugTarget.this.coroutines.clear();
                        }
                    } else if (event.getKind() == 8) {
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    }
                    ++n2;
                }
            }
        });
    }

    public void runToLine(URI uri, int lineNumber) throws DebugException {
        URI remoteUri = this.getPathMapper().map(uri);
        super.runToLine(remoteUri, lineNumber);
    }

    private void breakpoint(ChangeType changeType, IBreakpoint bp, IMarkerDelta markerDelta) {
        switch (changeType) {
            case ADD: {
                super.breakpointAdded(bp);
                break;
            }
            case UPDATE: {
                super.breakpointChanged(bp, markerDelta);
                break;
            }
            case REMOVE: {
                super.breakpointRemoved(bp, markerDelta);
                break;
            }
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        ChangeJob job = new ChangeJob(Messages.LuaDebugTargetUpdate, breakpoint, delta, ChangeType.UPDATE);
        job.setSystem(true);
        job.schedule();
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        ChangeJob job = new ChangeJob(Messages.LuaDebugTargetAdd, breakpoint, null, ChangeType.ADD);
        job.setSystem(true);
        job.schedule();
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        ChangeJob job = new ChangeJob(Messages.LuaDebugTargetRemove, breakpoint, delta, ChangeType.REMOVE);
        job.setSystem(true);
        job.schedule();
    }

    public IScriptThread getMainThread() {
        IThread[] threads = super.getThreads();
        return threads.length > 0 ? (IScriptThread)threads[0] : null;
    }

    public IThread[] getThreads() {
        ArrayList<Object> threads = new ArrayList<Object>();
        threads.addAll(Arrays.asList(super.getThreads()));
        if (threads.size() > 0 && ((IThread)threads.get(0)).isSuspended()) {
            threads.addAll(this.coroutines);
        }
        return threads.toArray(new IThread[threads.size()]);
    }

    final class ChangeJob
    extends Job {
        private ChangeType changeType;
        private IBreakpoint bp;
        private IMarkerDelta markerDelta;

        public ChangeJob(String name, IBreakpoint breakpoint, IMarkerDelta delta, ChangeType type) {
            super(name);
            this.bp = breakpoint;
            this.markerDelta = delta;
            this.changeType = type;
        }

        protected IStatus run(IProgressMonitor monitor) {
            LuaDebugTarget.this.breakpoint(this.changeType, this.bp, this.markerDelta);
            return Status.OK_STATUS;
        }
    }

    private static enum ChangeType {
        ADD,
        UPDATE,
        REMOVE;

    }
}

