/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.remote.debug.core.internal.sshprocess;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.koneki.ldt.remote.debug.core.internal.sshprocess.StreamsProxy;

public class SshProcess
implements IProcess {
    public static final char ARGUMENT_SEPARATOR = ' ';
    private ILaunch launch;
    private ChannelExec channelExec;
    private StreamsProxy sshStreamProxy;
    private String label;
    private Session currentSession;
    private String workingDir;

    public SshProcess(Session session, ILaunch launch, String workingDirectoryPath, String command, Map<String, String> envVars) throws CoreException {
        Channel channel;
        this.launch = launch;
        this.currentSession = session;
        this.workingDir = workingDirectoryPath;
        try {
            channel = session.openChannel("exec");
        }
        catch (JSchException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.koneki.ldt.remote.debug.core", "Unable to create SShProcess", (Throwable)e));
        }
        if (!(channel instanceof ChannelExec)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.koneki.ldt.remote.debug.core", "Unable to create SShProcess"));
        }
        this.channelExec = (ChannelExec)channel;
        this.label = command;
        String composedCommand = this.createLaunchCommand(workingDirectoryPath, command, envVars);
        this.channelExec.setCommand(composedCommand);
    }

    public static String escapeShell(String s) {
        return "\"" + s.replaceAll("\"", Matcher.quoteReplacement("\\\"")) + "\"";
    }

    public void start() throws CoreException {
        try {
            this.sshStreamProxy = new StreamsProxy(this.channelExec.getInputStream(), this.channelExec.getErrStream(), this.channelExec.getOutputStream(), null, null);
        }
        catch (IOException e) {
            this.terminate();
            throw new CoreException((IStatus)new Status(4, "org.eclipse.koneki.ldt.remote.debug.core", "Unable to start SShProcess", (Throwable)e));
        }
        try {
            this.channelExec.connect();
        }
        catch (JSchException e) {
            this.terminate();
            throw new CoreException((IStatus)new Status(4, "org.eclipse.koneki.ldt.remote.debug.core", "Unable to start SShProcess", (Throwable)e));
        }
        this.fireCreationEvent();
        new Thread(new Runnable(){

            @Override
            public void run() {
                boolean connected;
                do {
                    connected = SshProcess.this.channelExec.isConnected();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                } while (connected);
                SshProcess.this.sshStreamProxy.kill();
                SshProcess.this.fireTerminateEvent();
            }
        }).start();
    }

    private String createLaunchCommand(String workingDirectoryPath, String command, Map<String, String> envVars) {
        StringBuilder composedCommand = new StringBuilder();
        composedCommand.append("cd ");
        composedCommand.append(SshProcess.escapeShell(workingDirectoryPath));
        composedCommand.append(" && ");
        for (Map.Entry<String, String> entrySet : envVars.entrySet()) {
            composedCommand.append("export ");
            composedCommand.append(entrySet.getKey());
            composedCommand.append("=");
            composedCommand.append(SshProcess.escapeShell(entrySet.getValue()));
            composedCommand.append(" && ");
        }
        composedCommand.append("(");
        composedCommand.append("cat .PID > /dev/null 2>&1");
        composedCommand.append(" && ");
        composedCommand.append("kill `cat .PID` > /dev/null 2>&1");
        composedCommand.append(" && ");
        composedCommand.append("rm .PID > /dev/null 2>&1");
        composedCommand.append(")");
        composedCommand.append("; ");
        composedCommand.append("{ ");
        composedCommand.append(command);
        composedCommand.append(" & }");
        composedCommand.append(" && ");
        composedCommand.append("echo $! > .PID");
        composedCommand.append(" && ");
        composedCommand.append("wait $!");
        composedCommand.append(" && ");
        composedCommand.append("rm .PID");
        return composedCommand.toString();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.channelExec.isClosed();
    }

    public void terminate() throws DebugException {
        if (!this.isTerminated()) {
            SshProcess.killProcess(this.currentSession, this.workingDir);
        } else {
            this.sshStreamProxy.kill();
            this.fireTerminateEvent();
        }
    }

    private static String createKillCommand(String pidContainerFolder) {
        StringBuilder composedCommand = new StringBuilder();
        composedCommand.append("cd ");
        composedCommand.append(SshProcess.escapeShell(pidContainerFolder));
        composedCommand.append(" && ");
        composedCommand.append("kill `cat .PID`");
        composedCommand.append(" && ");
        composedCommand.append(" rm .PID");
        return composedCommand.toString();
    }

    public String getLabel() {
        return this.label;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IStreamsProxy getStreamsProxy() {
        return this.sshStreamProxy;
    }

    public void setAttribute(String key, String value) {
    }

    public String getAttribute(String key) {
        return null;
    }

    public int getExitValue() throws DebugException {
        return this.channelExec.getExitStatus();
    }

    protected void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    protected void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    protected void fireChangeEvent() {
        this.fireEvent(new DebugEvent((Object)this, 16));
    }

    public static void killProcess(Session session, String pidContainerFolder) throws DebugException {
        try {
            Channel channel = session.openChannel("exec");
            if (!(channel instanceof ChannelExec)) {
                throw new JSchException("Unable to create exec channel");
            }
            ChannelExec killChannel = (ChannelExec)channel;
            String killCommand = SshProcess.createKillCommand(pidContainerFolder);
            killChannel.setCommand(killCommand);
            killChannel.connect();
            int timeout = 5000;
            int period = 100;
            int i = 0;
            while (!channel.isClosed() && i * period < timeout) {
                try {
                    try {
                        Thread.sleep(period);
                    }
                    catch (InterruptedException interruptedException) {
                        ++i;
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    ++i;
                    throw throwable;
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.koneki.ldt.remote.debug.core", "An exception occurred when trying to stop the application.", (Throwable)e));
        }
    }
}

