/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.editor.text;

import org.eclipse.dltk.compiler.task.ITodoTaskPreferences;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.ScriptCommentScanner;
import org.eclipse.dltk.ui.text.ScriptPresentationReconciler;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.SingleTokenScriptScanner;
import org.eclipse.dltk.ui.text.completion.ContentAssistPreference;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.koneki.ldt.ui.internal.editor.completion.LuaCompletionProcessor;
import org.eclipse.koneki.ldt.ui.internal.editor.completion.LuaContentAssistPreference;
import org.eclipse.koneki.ldt.ui.internal.editor.text.ILuaPartitions;
import org.eclipse.koneki.ldt.ui.internal.editor.text.LuaCodeScanner;
import org.eclipse.koneki.ldt.ui.internal.editor.text.LuaDocumentorCommentAutoEditStrategy;
import org.eclipse.koneki.ldt.ui.internal.editor.text.LuaDocumentorScanner;
import org.eclipse.koneki.ldt.ui.internal.editor.text.LuaDoubleClickSelector;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class LuaSourceViewerConfiguration
extends ScriptSourceViewerConfiguration {
    private AbstractScriptScanner fCodeScanner;
    private AbstractScriptScanner fStringScanner;
    private AbstractScriptScanner fSingleQuoteStringScanner;
    private AbstractScriptScanner fMultilineStringScanner;
    private AbstractScriptScanner fCommentScanner;
    private AbstractScriptScanner fLuaDocScanner;
    private AbstractScriptScanner fMultilineCommentScanner;

    public LuaSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(colorManager, preferenceStore, editor, partitioning);
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new LuaDoubleClickSelector();
    }

    protected void alterContentAssistant(ContentAssistant assistant) {
        LuaCompletionProcessor scriptProcessor = new LuaCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)scriptProcessor, "__dftl_partition_content_type");
        LuaCompletionProcessor luaDocumentorProcessor = new LuaCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__lua_doc");
        assistant.setContentAssistProcessor((IContentAssistProcessor)luaDocumentorProcessor, "__lua_doc");
        assistant.setContentAssistProcessor((IContentAssistProcessor)luaDocumentorProcessor, "__lua_doc_multi_line");
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if ("__lua_doc".equals(contentType)) {
            return new IAutoEditStrategy[]{new LuaDocumentorCommentAutoEditStrategy()};
        }
        return new IAutoEditStrategy[]{new DefaultIndentLineAutoEditStrategy()};
    }

    protected ContentAssistPreference getContentAssistPreference() {
        return LuaContentAssistPreference.getDefault();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        ScriptPresentationReconciler reconciler = new ScriptPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.fCodeScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fStringScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__lua_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__lua_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fSingleQuoteStringScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__lua_single_quote_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__lua_single_quote_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fMultilineStringScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__lua_multi_line_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__lua_multi_line_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fMultilineCommentScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__lua_multi_line_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__lua_multi_line_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fCommentScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__lua_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__lua_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fLuaDocScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__lua_doc_multi_line");
        reconciler.setRepairer((IPresentationRepairer)dr, "__lua_doc_multi_line");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fLuaDocScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__lua_doc");
        reconciler.setRepairer((IPresentationRepairer)dr, "__lua_doc");
        return reconciler;
    }

    protected void initializeScanners() {
        this.fCodeScanner = new LuaCodeScanner(this.getColorManager(), this.fPreferenceStore);
        this.fStringScanner = new SingleTokenScriptScanner(this.getColorManager(), this.fPreferenceStore, "DLTK_string");
        this.fSingleQuoteStringScanner = new SingleTokenScriptScanner(this.getColorManager(), this.fPreferenceStore, "DLTK_string");
        this.fMultilineStringScanner = new SingleTokenScriptScanner(this.getColorManager(), this.fPreferenceStore, "DLTK_string");
        this.fMultilineCommentScanner = this.createCommentScanner("DLTK_multi_line_comment", "DLTK_comment_task_tag");
        this.fCommentScanner = this.createCommentScanner("DLTK_single_line_comment", "DLTK_comment_task_tag");
        this.fLuaDocScanner = new LuaDocumentorScanner(this);
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringScanner.affectsBehavior(event)) {
            this.fStringScanner.adaptToPreferenceChange(event);
        }
        if (this.fSingleQuoteStringScanner.affectsBehavior(event)) {
            this.fSingleQuoteStringScanner.adaptToPreferenceChange(event);
        }
        if (this.fMultilineStringScanner.affectsBehavior(event)) {
            this.fMultilineStringScanner.adaptToPreferenceChange(event);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(event)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fCommentScanner.affectsBehavior(event)) {
            this.fCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fLuaDocScanner.affectsBehavior(event)) {
            this.fLuaDocScanner.adaptToPreferenceChange(event);
        }
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        boolean affectCode = this.fCodeScanner.affectsBehavior(event);
        boolean affectString = this.fStringScanner.affectsBehavior(event) || this.fSingleQuoteStringScanner.affectsBehavior(event) || this.fMultilineStringScanner.affectsBehavior(event);
        boolean affectComments = this.fCommentScanner.affectsBehavior(event) || this.fMultilineCommentScanner.affectsBehavior(event);
        boolean affectLuaDoc = this.fLuaDocScanner.affectsBehavior(event);
        return affectCode || affectString || affectComments || affectLuaDoc;
    }

    protected String getCommentPrefix() {
        return "--";
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return ILuaPartitions.LUA_PARTITION_TYPES;
    }

    protected AbstractScriptScanner createCommentScanner(String commentColor, String tagColor, ITodoTaskPreferences taskPrefs) {
        return new ScriptCommentScanner(this.getColorManager(), this.fPreferenceStore, commentColor, tagColor, taskPrefs){

            protected int skipCommentChars() {
                if (this.read() == 45) {
                    if (this.read() == 45) {
                        return 2;
                    }
                    this.unread();
                    this.unread();
                    return 0;
                }
                this.unread();
                return 0;
            }
        };
    }
}

