/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core.internal.ast.parser;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaASTNode;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LocalVar;
import org.eclipse.koneki.ldt.core.internal.ast.parser.OffsetFixer;

public class EncodingVisitor
extends ASTVisitor {
    private final OffsetFixer fixer;
    private final int sourceLength;

    public EncodingVisitor(OffsetFixer offsetFixer) {
        this.fixer = offsetFixer;
        this.sourceLength = this.fixer.getCharactersLength();
    }

    public boolean visitGeneral(ASTNode node) throws Exception {
        if (!(node instanceof LuaASTNode)) {
            return true;
        }
        LuaASTNode luaNode = (LuaASTNode)node;
        luaNode.setStart(this.fixer.getCharacterPosition(luaNode.sourceStart()));
        int nodeEnd = this.fixer.getCharacterPosition(luaNode.sourceEnd());
        if (nodeEnd <= this.sourceLength) {
            luaNode.setEnd(nodeEnd);
        }
        if (luaNode instanceof LocalVar) {
            LocalVar localVar = (LocalVar)luaNode;
            localVar.setScopeMinOffset(this.fixer.getCharacterPosition(localVar.getScopeMinOffset()));
            localVar.setScopeMaxOffset(this.fixer.getCharacterPosition(localVar.getScopeMaxOffset()));
        }
        return true;
    }
}

