/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.internal.callgraph.core.Messages;
import org.eclipse.linuxtools.internal.callgraph.core.PluginConstants;
import org.eclipse.linuxtools.internal.callgraph.core.StapUIJob;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapUIErrorMessages;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapView;

public abstract class SystemTapParser
extends Job {
    protected IProgressMonitor monitor;
    protected String sourcePath;
    protected String viewID;
    protected SystemTapView view;
    protected boolean realTime = false;
    protected Object data;
    protected Object internalData;
    private String secondaryID = "";
    public boolean done;

    public SystemTapParser() {
        super("Parsing data");
        this.sourcePath = PluginConstants.getDefaultIOPath();
        this.viewID = null;
        this.initialize();
        this.done = false;
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
    }

    public SystemTapParser(String name, String filePath) {
        super(name);
        this.sourcePath = filePath != null ? filePath : PluginConstants.getDefaultIOPath();
        this.viewID = null;
        this.initialize();
    }

    protected abstract void initialize();

    public abstract IStatus nonRealTimeParsing();

    public abstract IStatus realTimeParsing();

    protected String cleanFunctionName(String name) {
        return name.split("\"")[0];
    }

    protected boolean isFunctionNameClean(String name) {
        return !name.contains("\"") && !name.contains(")");
    }

    protected void parsingError(String message) {
        SystemTapUIErrorMessages mess = new SystemTapUIErrorMessages(Messages.getString("SystemTapParser.ParseErr"), Messages.getString("SystemTapParser.ErrSymbol"), message);
        mess.schedule();
    }

    protected boolean makeView() {
        if (this.viewID != null && this.viewID.length() > 0) {
            try {
                StapUIJob uijob = new StapUIJob(Messages.getString("StapGraphParser.JobName"), this, this.viewID);
                uijob.schedule();
                uijob.join();
                this.view = uijob.getViewer();
                return true;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus returnStatus = Status.CANCEL_STATUS;
        this.monitor = monitor;
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        this.makeView();
        if (this.realTime) {
            try {
                this.setInternalData();
                while (!this.done) {
                    returnStatus = this.realTimeParsing();
                    if (monitor.isCanceled() || returnStatus == Status.CANCEL_STATUS) {
                        this.done = true;
                        return Status.CANCEL_STATUS;
                    }
                    Thread.sleep(500L);
                }
                if (!monitor.isCanceled()) {
                    returnStatus = this.realTimeParsing();
                }
                this.done = true;
                return returnStatus;
            }
            catch (InterruptedException e) {
                SystemTapUIErrorMessages m = new SystemTapUIErrorMessages(Messages.getString("SystemTapParser.InternalData"), Messages.getString("SystemTapParser.FailedToSetData"), Messages.getString("SystemTapParser.FailedToSetDataMessage"));
                m.schedule();
                return Status.CANCEL_STATUS;
            }
            catch (FileNotFoundException e) {
                SystemTapUIErrorMessages m = new SystemTapUIErrorMessages(Messages.getString("SystemTapParser.InternalData"), Messages.getString("SystemTapParser.FailedToSetData"), Messages.getString("SystemTapParser.FailedToSetDataMessage"));
                m.schedule();
                return Status.CANCEL_STATUS;
            }
        }
        returnStatus = this.nonRealTimeParsing();
        if (!returnStatus.isOK()) {
            return returnStatus;
        }
        this.setData((Object)this);
        return returnStatus;
    }

    public IStatus testRun(IProgressMonitor m, boolean realTime) {
        try {
            this.internalData = new BufferedReader(new FileReader(new File(this.sourcePath)));
            if (realTime) {
                return this.realTimeParsing();
            }
            return this.nonRealTimeParsing();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return Status.CANCEL_STATUS;
        }
    }

    public void launchFileErrorDialog() {
        SystemTapUIErrorMessages err = new SystemTapUIErrorMessages(Messages.getString("SystemTapParser.InvalidFile"), Messages.getString("SystemTapParser.InvalidFile"), String.valueOf(Messages.getString("SystemTapParser.InvalidFileMsg1")) + this.sourcePath + Messages.getString("SystemTapParser.InvalidFileMsg2"));
        err.schedule();
    }

    public Object getData() {
        return this.data;
    }

    public Object getInternalData() {
        return this.internalData;
    }

    protected void setInternalData() throws FileNotFoundException {
        File file = new File(this.sourcePath);
        this.internalData = new BufferedReader(new FileReader(file));
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public String getFile() {
        return this.sourcePath;
    }

    public void setSourcePath(String source) {
        this.sourcePath = source;
    }

    public void setDone(boolean val) {
        this.done = val;
    }

    public void setMonitor(IProgressMonitor m) {
        this.monitor = m;
    }

    public void setRealTime(boolean val) {
        this.realTime = val;
    }

    public void setViewID(String value) {
        this.viewID = value;
    }

    public void setData(Object obj) {
        this.data = obj;
    }

    public void cancelJob() {
        this.done = true;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setKillButtonEnabled(boolean val) {
        if (this.view != null) {
            this.view.setKillButtonEnabled(val);
        }
    }

    public boolean isRealTime() {
        return this.realTime;
    }

    public void setSecondaryID(String secondaryID) {
        this.secondaryID = secondaryID;
    }

    public String getSecondaryID() {
        return this.secondaryID;
    }
}

