/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.devhelp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.cdt.libhover.FunctionInfo;
import org.eclipse.linuxtools.cdt.libhover.LibHoverInfo;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.preferences.LibHoverMessages;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ParseDevHelp {
    private static final String PARSING_MSG = "Libhover.Devhelp.Parsing.msg";
    private static final String PARSING_FMT_MSG = "Libhover.Devhelp.Parsing.fmt.msg";

    public static void main(String[] args) {
        String devhelpHtmlDirectory = args[0];
        DevHelpParser p = new DevHelpParser(devhelpHtmlDirectory, true);
        File dir = new File(devhelpHtmlDirectory);
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            String name = f.getName();
            p.parse(String.valueOf(f.getAbsolutePath()) + "/" + name + ".devhelp2", (IProgressMonitor)new NullProgressMonitor());
            ++i;
        }
        LibHoverInfo hover = p.getLibHoverInfo();
        try {
            Path workspaceDir = new Path(args[1]);
            IPath location = workspaceDir.append("org.eclipse.linuxtools.cdt.libhover/C");
            File ldir = new File(location.toOSString());
            ldir.mkdir();
            location = location.append("devhelp.libhover");
            FileOutputStream f = new FileOutputStream(location.toOSString());
            ObjectOutputStream out = new ObjectOutputStream(f);
            out.writeObject(hover);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Parse Complete");
    }

    public static class DevHelpParser {
        private String dirName;
        private LibHoverInfo libhover;
        private boolean debug;

        public DevHelpParser(String dirName) {
            this(dirName, false);
        }

        public DevHelpParser(String dirName, boolean debug) {
            this.dirName = dirName;
            this.libhover = new LibHoverInfo();
            this.debug = debug;
        }

        public LibHoverInfo getLibHoverInfo() {
            return this.libhover;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public LibHoverInfo parse(IProgressMonitor monitor) {
            try {
                IFileSystem fs = EFS.getLocalFileSystem();
                Path dirPath = new Path(this.dirName);
                IFileStore htmlDir = fs.getStore((IPath)dirPath);
                IFileStore[] files = htmlDir.childStores(0, null);
                monitor.beginTask(LibHoverMessages.getString(ParseDevHelp.PARSING_MSG), files.length);
                Arrays.sort(files, new Comparator<IFileStore>(){

                    @Override
                    public int compare(IFileStore arg0, IFileStore arg1) {
                        return arg0.getName().compareToIgnoreCase(arg1.getName());
                    }
                });
                int i = 0;
                while (true) {
                    if (i >= files.length) {
                        return this.libhover;
                    }
                    IFileStore file = files[i];
                    String name = file.fetchInfo().getName();
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    monitor.setTaskName(LibHoverMessages.getFormattedString(ParseDevHelp.PARSING_FMT_MSG, new String[]{name}));
                    File f = new File(dirPath.append(name).append(String.valueOf(name) + ".devhelp2").toOSString());
                    if (f.exists()) {
                        this.parse(dirPath.append(name).append(String.valueOf(name) + ".devhelp2").toOSString(), monitor);
                    } else {
                        this.parse(dirPath.append(name).append(String.valueOf(name) + ".devhelp").toOSString(), monitor);
                    }
                    monitor.worked(1);
                    ++i;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return this.libhover;
        }

        private void parseLink(Node link, Node name, IPath path, LibHoverInfo libhover) {
            String linkValue = link.getNodeValue();
            String[] linkParts = linkValue.split("#");
            if (linkParts.length == 2) {
                try {
                    String nameString = name.getNodeValue();
                    nameString = nameString.replaceAll("\\(.*\\);+", "").trim();
                    if (nameString.contains("::") || nameString.startsWith("enum ") || nameString.contains("\"")) {
                        return;
                    }
                    FileReader reader = new FileReader(String.valueOf(path.removeLastSegments(1).toOSString()) + "/" + linkParts[0]);
                    Parser callback = new Parser(linkParts[1], nameString);
                    new ParserDelegator().parse(reader, callback, true);
                    FunctionInfo finfo = callback.getFunctionInfo();
                    if (finfo != null) {
                        if (this.debug) {
                            System.out.println(callback.toString());
                        }
                        libhover.functions.put(callback.getFuncName(), callback.getFunctionInfo());
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void parse(String fileName, IProgressMonitor monitor) {
            try {
                NamedNodeMap m;
                Node n;
                Path path = new Path(fileName);
                File f = new File(fileName);
                FileInputStream stream = new FileInputStream(f);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setEntityResolver(new EntityResolver(){

                    @Override
                    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                        return new InputSource(new StringReader(""));
                    }
                });
                Document doc = builder.parse(stream);
                NodeList bookNodes = doc.getElementsByTagName("book");
                int x = 0;
                while (x < bookNodes.getLength()) {
                    Node n2 = bookNodes.item(x);
                    NamedNodeMap m2 = n2.getAttributes();
                    Node language = m2.getNamedItem("language");
                    if (language != null && !language.getNodeValue().equals("c")) {
                        return;
                    }
                    ++x;
                }
                if (path.lastSegment().endsWith("devhelp")) {
                    NodeList nl = doc.getElementsByTagName("function");
                    int i = 0;
                    while (i < nl.getLength()) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        n = nl.item(i);
                        m = n.getAttributes();
                        Node name = m.getNamedItem("name");
                        Node link = m.getNamedItem("link");
                        if (link != null) {
                            this.parseLink(link, name, (IPath)path, this.libhover);
                        }
                        ++i;
                    }
                } else if (path.lastSegment().endsWith("devhelp2")) {
                    NodeList nl = doc.getElementsByTagName("keyword");
                    int i = 0;
                    while (i < nl.getLength()) {
                        String typeName;
                        if (monitor.isCanceled()) {
                            return;
                        }
                        n = nl.item(i);
                        m = n.getAttributes();
                        Node type = m.getNamedItem("type");
                        if (type != null && (typeName = type.getNodeValue()).equals("function")) {
                            Node name = m.getNamedItem("name");
                            Node link = m.getNamedItem("link");
                            if (link != null) {
                                this.parseLink(link, name, (IPath)path, this.libhover);
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (FileNotFoundException path) {
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static class Parser
    extends HTMLEditorKit.ParserCallback {
        private String func;
        private boolean begin;
        private boolean returnType;
        private boolean protoStart;
        private boolean parmStart;
        private boolean descStart;
        private boolean rowIgnore;
        private boolean valid = true;
        private String returnValue;
        private String funcName;
        private String rowTag;
        private String prototype = "";
        private String description = "";
        private int divCounter;
        private int rowItemCount;

        public Parser(String func, String funcName) {
            this.func = func;
            this.funcName = funcName.trim();
            if (this.funcName.endsWith("()")) {
                this.funcName = this.funcName.replaceAll("\\(\\)", "").trim();
            }
        }

        @Override
        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            String name;
            if (t == HTML.Tag.A && this.func.equals(name = (String)a.getAttribute(HTML.Attribute.NAME))) {
                this.begin = true;
            }
            if (this.begin) {
                String type;
                if (t == HTML.Tag.DIV) {
                    ++this.divCounter;
                }
                if (!this.descStart) {
                    if (t == HTML.Tag.SPAN) {
                        type = (String)a.getAttribute(HTML.Attribute.CLASS);
                        if (this.returnValue == null && type != null && type.equals("returnvalue")) {
                            this.returnType = true;
                        }
                    }
                    if (t == HTML.Tag.PRE && (type = (String)a.getAttribute(HTML.Attribute.CLASS)) != null && type.equals("programlisting")) {
                        this.returnType = true;
                    }
                }
                if (this.protoStart) {
                    if (t == HTML.Tag.P) {
                        this.protoStart = false;
                        this.descStart = true;
                        this.description = String.valueOf(this.description) + "<p>";
                    }
                } else if (this.descStart) {
                    if (t == HTML.Tag.P) {
                        this.description = String.valueOf(this.description) + "<p>";
                    } else if (t == HTML.Tag.TABLE) {
                        this.description = String.valueOf(this.description) + "<dl>";
                    } else if (t == HTML.Tag.TR) {
                        this.rowItemCount = 0;
                    } else if (t == HTML.Tag.TD) {
                        type = (String)a.getAttribute(HTML.Attribute.CLASS);
                        if (type != null && type.equals("listing_lines")) {
                            this.rowIgnore = true;
                        } else {
                            this.rowIgnore = false;
                            this.rowTag = this.rowItemCount++ == 0 ? "<dt>" : "<dd>";
                            this.description = String.valueOf(this.description) + this.rowTag;
                        }
                    }
                }
            }
        }

        @Override
        public void handleEndTag(HTML.Tag t, int pos) {
            if (this.begin) {
                if (t == HTML.Tag.DIV) {
                    --this.divCounter;
                    if (this.divCounter <= 0) {
                        this.begin = false;
                        try {
                            this.flush();
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (this.descStart) {
                    if (t == HTML.Tag.P) {
                        this.description = String.valueOf(this.description) + "</p>";
                    } else if (t == HTML.Tag.TABLE) {
                        this.description = String.valueOf(this.description) + "</dl>";
                    } else if (t == HTML.Tag.TR) {
                        this.rowItemCount = 0;
                    } else if (t == HTML.Tag.TD) {
                        if (!this.rowIgnore) {
                            this.description = this.rowTag != null && this.rowTag.equals("<dt>") ? String.valueOf(this.description) + "</dt>" : String.valueOf(this.description) + "</dd>";
                        }
                        this.rowIgnore = false;
                    }
                }
            }
        }

        @Override
        public void handleText(char[] data, int pos) {
            if (this.begin) {
                if (this.returnType) {
                    this.returnValue = "";
                    String tmp = String.valueOf(data).trim();
                    boolean completed = false;
                    if (tmp.endsWith(");")) {
                        completed = true;
                        tmp = tmp.substring(0, tmp.length() - 2);
                    }
                    String[] tokens = tmp.split("\\s+");
                    String separator = "";
                    this.protoStart = true;
                    int i = 0;
                    while (i < tokens.length) {
                        String token = tokens[i];
                        if (token.equals(this.funcName)) {
                            separator = "";
                            int j = i + 1;
                            while (j < tokens.length) {
                                String jtoken = tokens[j];
                                if (j == i + 1 && jtoken.charAt(0) == '(') {
                                    jtoken = jtoken.substring(1);
                                    this.parmStart = true;
                                    this.protoStart = false;
                                }
                                this.prototype = String.valueOf(this.prototype) + separator + jtoken;
                                separator = " ";
                                ++j;
                            }
                            if (!this.parmStart || !completed) break;
                            this.parmStart = false;
                            this.descStart = true;
                            break;
                        }
                        this.returnValue = String.valueOf(this.returnValue) + separator + token;
                        separator = " ";
                        ++i;
                    }
                    this.returnType = false;
                } else if (this.protoStart) {
                    String temp = String.valueOf(data).trim();
                    boolean completed = false;
                    if (temp.endsWith(");")) {
                        completed = true;
                        temp = temp.substring(0, temp.length() - 2);
                    }
                    String separator = " ";
                    while (temp.startsWith("*") || temp.startsWith("const")) {
                        if (temp.charAt(0) == '*') {
                            this.returnValue = String.valueOf(this.returnValue) + separator + "*";
                            temp = temp.substring(1).trim();
                            separator = "";
                            continue;
                        }
                        this.returnValue = String.valueOf(this.returnValue) + "const";
                        temp = temp.substring(5).trim();
                        separator = " ";
                    }
                    int index = temp.lastIndexOf(40);
                    int index2 = temp.lastIndexOf(41);
                    if (index2 < index) {
                        if (index + 1 < temp.length()) {
                            temp = temp.substring(index + 1).trim();
                            this.prototype = String.valueOf(this.prototype) + temp;
                        }
                        this.parmStart = true;
                        this.protoStart = false;
                    }
                    if (this.parmStart && completed) {
                        this.parmStart = false;
                        this.descStart = true;
                    }
                } else if (this.parmStart) {
                    String parmData = String.valueOf(data).trim();
                    int index = parmData.indexOf(41);
                    if (index >= 0) {
                        this.parmStart = false;
                        this.descStart = true;
                        parmData = parmData.substring(0, index);
                    }
                    if (!(this.prototype.equals("") || parmData.equals(",") || parmData.equals(""))) {
                        parmData = " " + parmData;
                    }
                    this.prototype = String.valueOf(this.prototype) + parmData;
                } else if (this.descStart && !this.rowIgnore) {
                    this.description = String.valueOf(this.description) + String.valueOf(data);
                }
            }
        }

        public FunctionInfo getFunctionInfo() {
            if (!this.valid || this.returnValue == null || this.returnValue.startsWith("#") || this.returnValue.startsWith("typedef ")) {
                return null;
            }
            FunctionInfo info = new FunctionInfo(this.funcName);
            info.setReturnType(this.returnValue);
            info.setPrototype(this.prototype);
            info.setDescription(this.description);
            return info;
        }

        public String getFuncName() {
            return this.funcName;
        }

        public String toString() {
            return "funcName: <" + this.funcName + "> returnType: <" + this.returnValue + "> prototype: <" + this.prototype + "> description: " + this.description;
        }

        @Override
        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        }
    }

    public static class UpdateDevhelp
    extends Job {
        public UpdateDevhelp(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            return null;
        }
    }
}

