/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.dataviewers.charts.view;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.linuxtools.internal.dataviewers.charts.Activator;
import org.eclipse.linuxtools.internal.dataviewers.charts.actions.SaveChartAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.swtchart.Chart;

public class ChartView
extends ViewPart {
    public static final String VIEW_ID = "org.eclipse.linuxtools.dataviewers.charts.view";
    private static int SEC_ID = 0;
    private static final Object lock = new Object();
    private Composite parent;
    private SaveChartAction saveChartAction;

    public static void createChartView(final Chart chart) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = lock;
                    synchronized (object) {
                        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        int n = SEC_ID;
                        SEC_ID = n + 1;
                        ChartView view = (ChartView)iWorkbenchPage.showView(ChartView.VIEW_ID, String.valueOf(n), 1);
                        view.setChart(chart);
                    }
                }
                catch (PartInitException e) {
                    Status s = new Status(4, "org.eclipse.linuxtools.dataviewers.charts", 4, e.getMessage(), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)s);
                }
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.createActions(parent);
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.initToolBar(actionBars.getToolBarManager());
    }

    protected void createActions(Composite parent) {
        this.saveChartAction = new SaveChartAction(this.getViewSite().getShell(), this);
    }

    protected void initToolBar(IToolBarManager manager) {
        manager.add((IAction)this.saveChartAction);
        manager.update(true);
    }

    public void setFocus() {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.setFocus();
        }
    }

    public void setChart(Chart chart) {
        this.saveChartAction.setChart(chart);
    }

    public Composite getParent() {
        return this.parent;
    }

    public static int getSecId() {
        return SEC_ID;
    }
}

