/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gdbtrace.ui.views.events;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.linuxtools.internal.gdbtrace.core.event.GdbTraceEvent;
import org.eclipse.linuxtools.internal.gdbtrace.core.event.GdbTraceEventContent;
import org.eclipse.linuxtools.internal.gdbtrace.core.trace.GdbTrace;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.TmfEventField;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.ui.viewers.events.TmfEventsTable;
import org.eclipse.linuxtools.tmf.ui.widgets.virtualtable.ColumnData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;

public class GdbEventsTable
extends TmfEventsTable {
    private static final String TRACE_FRAME_COLUMN = "Trace Frame";
    private static final String TRACEPOINT_COLUMN = "Tracepoint";
    private static final String FILE_COLUMN = "File";
    private static final String CONTENT_COLUMN = "Content";
    private static final ColumnData[] COLUMN_DATA = new ColumnData[]{new ColumnData("Trace Frame", 100, 131072), new ColumnData("Tracepoint", 100, 131072), new ColumnData("File", 100, 16384), new ColumnData("Content", 100, 16384)};
    private GdbTrace fSelectedTrace = null;
    private long fSelectedFrame = 0L;

    public GdbEventsTable(Composite parent, int cacheSize) {
        super(parent, cacheSize, COLUMN_DATA);
        this.fTable.getColumns()[2].setData("$field_id", (Object)":reference:");
        this.fTable.getColumns()[3].setData("$field_id", (Object)":content:");
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                Object data;
                TableItem selectedTableItem;
                TableItem[] selection = GdbEventsTable.this.fTable.getSelection();
                if (selection.length > 0 && (selectedTableItem = selection[0]) != null && (data = selectedTableItem.getData()) instanceof GdbTraceEvent) {
                    GdbTraceEvent event = (GdbTraceEvent)data;
                    GdbTrace gdbTrace = (GdbTrace)event.getTrace();
                    GdbTraceEventContent content = (GdbTraceEventContent)event.getContent();
                    gdbTrace.selectFrame((long)content.getFrameNumber());
                    GdbEventsTable.this.fSelectedTrace = gdbTrace;
                    GdbEventsTable.this.fSelectedFrame = content.getFrameNumber();
                    return;
                }
                GdbEventsTable.this.fSelectedTrace = null;
            }
        });
    }

    public void setTrace(ITmfTrace trace, boolean disposeOnClose) {
        TmfExperiment experiment;
        super.setTrace(trace, disposeOnClose);
        if (trace instanceof GdbTrace) {
            this.fSelectedTrace = (GdbTrace)trace;
            this.fSelectedFrame = 0L;
        } else if (trace instanceof TmfExperiment && (experiment = (TmfExperiment)trace).getTraces().length > 0) {
            this.fSelectedTrace = (GdbTrace)experiment.getTraces()[0];
            this.fSelectedFrame = 0L;
        }
    }

    protected void populateCompleted() {
        if (this.fSelectedTrace != null) {
            this.fSelectedTrace.selectFrame(this.fSelectedFrame);
        }
    }

    protected ITmfEventField[] extractItemFields(ITmfEvent event) {
        TmfEventField[] fields = new TmfEventField[]{};
        if (event != null) {
            GdbTraceEventContent content = (GdbTraceEventContent)event.getContent();
            fields = new TmfEventField[]{new TmfEventField(TRACE_FRAME_COLUMN, (Object)content.getFrameNumber(), null), new TmfEventField(TRACEPOINT_COLUMN, (Object)content.getTracepointNumber(), null), new TmfEventField(FILE_COLUMN, (Object)event.getReference(), null), new TmfEventField(CONTENT_COLUMN, (Object)content.toString(), null)};
        }
        return fields;
    }

    @TmfSignalHandler
    public void currentTimeUpdated(TmfTimeSynchSignal signal) {
    }
}

