/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.Messages;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources.ResourcesEntry;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources.ResourcesPresentationProvider;
import org.eclipse.linuxtools.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateSystem;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.linuxtools.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class ResourcesView
extends AbstractTimeGraphView {
    public static final String ID = "org.eclipse.linuxtools.lttng2.kernel.ui.views.resources";
    private static final String[] FILTER_COLUMN_NAMES = new String[]{Messages.ResourcesView_stateTypeName};

    public ResourcesView() {
        super(ID, (TimeGraphPresentationProvider)new ResourcesPresentationProvider());
        this.setFilterColumns(FILTER_COLUMN_NAMES);
    }

    protected String getNextText() {
        return Messages.ResourcesView_nextResourceActionNameText;
    }

    protected String getNextTooltip() {
        return Messages.ResourcesView_nextResourceActionToolTipText;
    }

    protected String getPrevText() {
        return Messages.ResourcesView_previousResourceActionNameText;
    }

    protected String getPrevTooltip() {
        return Messages.ResourcesView_previousResourceActionToolTipText;
    }

    protected void buildEventList(ITmfTrace trace, IProgressMonitor monitor) {
        this.setStartTime(Long.MAX_VALUE);
        this.setEndTime(Long.MIN_VALUE);
        ArrayList<ResourcesEntry> entryList = new ArrayList<ResourcesEntry>();
        ITmfTrace[] iTmfTraceArray = TmfTraceManager.getTraceSet((ITmfTrace)trace);
        int n = iTmfTraceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace aTrace = iTmfTraceArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (aTrace instanceof LttngKernelTrace) {
                LttngKernelTrace lttngKernelTrace = (LttngKernelTrace)aTrace;
                ITmfStateSystem ssq = (ITmfStateSystem)lttngKernelTrace.getStateSystems().get("org.eclipse.linuxtools.lttng2.kernel");
                if (!ssq.waitUntilBuilt()) {
                    return;
                }
                long startTime = ssq.getStartTime();
                long endTime = ssq.getCurrentEndTime() + 1L;
                ResourcesEntry groupEntry = new ResourcesEntry(lttngKernelTrace, aTrace.getName(), startTime, endTime, 0);
                entryList.add(groupEntry);
                this.setStartTime(Math.min(this.getStartTime(), startTime));
                this.setEndTime(Math.max(this.getEndTime(), endTime));
                List cpuQuarks = ssq.getQuarks(new String[]{"CPUs", "*"});
                ResourcesEntry[] cpuEntries = new ResourcesEntry[cpuQuarks.size()];
                int i = 0;
                while (i < cpuQuarks.size()) {
                    int cpuQuark = (Integer)cpuQuarks.get(i);
                    int cpu = Integer.parseInt(ssq.getAttributeName(cpuQuark));
                    ResourcesEntry entry = new ResourcesEntry(cpuQuark, lttngKernelTrace, this.getStartTime(), this.getEndTime(), ResourcesEntry.Type.CPU, cpu);
                    groupEntry.addChild(entry);
                    cpuEntries[i] = entry;
                    ++i;
                }
                List irqQuarks = ssq.getQuarks(new String[]{"Resources", "IRQs", "*"});
                ResourcesEntry[] irqEntries = new ResourcesEntry[irqQuarks.size()];
                int i2 = 0;
                while (i2 < irqQuarks.size()) {
                    int irqQuark = (Integer)irqQuarks.get(i2);
                    int irq = Integer.parseInt(ssq.getAttributeName(irqQuark));
                    ResourcesEntry entry = new ResourcesEntry(irqQuark, lttngKernelTrace, this.getStartTime(), this.getEndTime(), ResourcesEntry.Type.IRQ, irq);
                    groupEntry.addChild(entry);
                    irqEntries[i2] = entry;
                    ++i2;
                }
                List softIrqQuarks = ssq.getQuarks(new String[]{"Resources", "Soft_IRQs", "*"});
                ResourcesEntry[] softIrqEntries = new ResourcesEntry[softIrqQuarks.size()];
                int i3 = 0;
                while (i3 < softIrqQuarks.size()) {
                    int softIrqQuark = (Integer)softIrqQuarks.get(i3);
                    int softIrq = Integer.parseInt(ssq.getAttributeName(softIrqQuark));
                    ResourcesEntry entry = new ResourcesEntry(softIrqQuark, lttngKernelTrace, this.getStartTime(), this.getEndTime(), ResourcesEntry.Type.SOFT_IRQ, softIrq);
                    groupEntry.addChild(entry);
                    softIrqEntries[i3] = entry;
                    ++i3;
                }
            }
            ++n2;
        }
        this.putEntryList(trace, new ArrayList(entryList));
        if (trace.equals(this.getTrace())) {
            this.refresh();
        }
        for (ResourcesEntry traceEntry : entryList) {
            if (monitor.isCanceled()) {
                return;
            }
            LttngKernelTrace lttngKernelTrace = traceEntry.getTrace();
            ITmfStateSystem ssq = (ITmfStateSystem)lttngKernelTrace.getStateSystems().get("org.eclipse.linuxtools.lttng2.kernel");
            long startTime = ssq.getStartTime();
            long endTime = ssq.getCurrentEndTime() + 1L;
            long resolution = (endTime - startTime) / (long)this.getDisplayWidth();
            for (TimeGraphEntry entry : traceEntry.getChildren()) {
                List<ITimeEvent> eventList = this.getEventList(entry, startTime, endTime, resolution, monitor);
                entry.setEventList(eventList);
                this.redraw();
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected List<ITimeEvent> getEventList(TimeGraphEntry entry, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        ResourcesEntry resourcesEntry = (ResourcesEntry)entry;
        ITmfStateSystem ssq = (ITmfStateSystem)resourcesEntry.getTrace().getStateSystems().get("org.eclipse.linuxtools.lttng2.kernel");
        long realStart = Math.max(startTime, ssq.getStartTime());
        long realEnd = Math.min(endTime, ssq.getCurrentEndTime() + 1L);
        if (realEnd <= realStart) {
            return null;
        }
        ArrayList<Object> eventList = null;
        int quark = resourcesEntry.getQuark();
        try {
            if (resourcesEntry.getType().equals((Object)ResourcesEntry.Type.CPU)) {
                int statusQuark = ssq.getQuarkRelative(quark, new String[]{"Status"});
                List statusIntervals = ssq.queryHistoryRange(statusQuark, realStart, realEnd - 1L, resolution, monitor);
                eventList = new ArrayList(statusIntervals.size());
                long lastEndTime = -1L;
                for (ITmfStateInterval statusInterval : statusIntervals) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    int status = statusInterval.getStateValue().unboxInt();
                    long time = statusInterval.getStartTime();
                    long duration = statusInterval.getEndTime() - time + 1L;
                    if (!statusInterval.getStateValue().isNull()) {
                        if (lastEndTime != time && lastEndTime != -1L) {
                            eventList.add(new TimeEvent((ITimeGraphEntry)entry, lastEndTime, time - lastEndTime));
                        }
                        eventList.add(new TimeEvent((ITimeGraphEntry)entry, time, duration, status));
                    } else if (lastEndTime == -1L || time + duration >= endTime) {
                        eventList.add(new NullTimeEvent((ITimeGraphEntry)entry, time, duration));
                    }
                    lastEndTime = time + duration;
                }
            } else if (resourcesEntry.getType().equals((Object)ResourcesEntry.Type.IRQ)) {
                List irqIntervals = ssq.queryHistoryRange(quark, realStart, realEnd - 1L, resolution, monitor);
                eventList = new ArrayList<Object>(irqIntervals.size());
                long lastEndTime = -1L;
                boolean lastIsNull = true;
                for (ITmfStateInterval irqInterval : irqIntervals) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    long time = irqInterval.getStartTime();
                    long duration = irqInterval.getEndTime() - time + 1L;
                    if (!irqInterval.getStateValue().isNull()) {
                        int cpu = irqInterval.getStateValue().unboxInt();
                        eventList.add(new TimeEvent((ITimeGraphEntry)entry, time, duration, cpu));
                        lastIsNull = false;
                    } else {
                        if (lastEndTime == -1L) {
                            eventList.add(new NullTimeEvent((ITimeGraphEntry)entry, time, duration));
                        } else {
                            if (lastEndTime != time && lastIsNull) {
                                eventList.add(new TimeEvent((ITimeGraphEntry)entry, lastEndTime, time - lastEndTime, -1));
                            }
                            if (time + duration >= endTime) {
                                eventList.add(new NullTimeEvent((ITimeGraphEntry)entry, time, duration));
                            }
                        }
                        lastIsNull = true;
                    }
                    lastEndTime = time + duration;
                }
            } else if (resourcesEntry.getType().equals((Object)ResourcesEntry.Type.SOFT_IRQ)) {
                List softIrqIntervals = ssq.queryHistoryRange(quark, realStart, realEnd - 1L, resolution, monitor);
                eventList = new ArrayList(softIrqIntervals.size());
                long lastEndTime = -1L;
                boolean lastIsNull = true;
                for (ITmfStateInterval softIrqInterval : softIrqIntervals) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    long time = softIrqInterval.getStartTime();
                    long duration = softIrqInterval.getEndTime() - time + 1L;
                    if (!softIrqInterval.getStateValue().isNull()) {
                        int cpu = softIrqInterval.getStateValue().unboxInt();
                        eventList.add(new TimeEvent((ITimeGraphEntry)entry, time, duration, cpu));
                    } else {
                        if (lastEndTime == -1L) {
                            eventList.add(new NullTimeEvent((ITimeGraphEntry)entry, time, duration));
                        } else {
                            if (lastEndTime != time && lastIsNull) {
                                eventList.add(new TimeEvent((ITimeGraphEntry)entry, lastEndTime, time - lastEndTime, -1));
                            }
                            if (time + duration >= endTime) {
                                eventList.add(new NullTimeEvent((ITimeGraphEntry)entry, time, duration));
                            }
                        }
                        lastIsNull = true;
                    }
                    lastEndTime = time + duration;
                }
            }
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        catch (TimeRangeException e) {
            e.printStackTrace();
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return eventList;
    }
}

