/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.ITraceControlComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.ITraceControlComponentChangedListener;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceControlContentProvider;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceControlLabelProvider;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceControlRoot;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class ControlView
extends ViewPart
implements ITraceControlComponentChangedListener {
    public static final String ID = "org.eclipse.linuxtools.internal.lttng2.ui.views.control";
    private TreeViewer fTreeViewer = null;
    private ITraceControlComponent fRoot = null;

    public ITraceControlComponent getTraceControlRoot() {
        return this.fRoot;
    }

    public void createPartControl(Composite parent) {
        this.fTreeViewer = new TreeViewer(parent, 770);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fTreeViewer);
        this.fTreeViewer.setContentProvider((IContentProvider)new TraceControlContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new TraceControlLabelProvider());
        this.fRoot = new TraceControlRoot();
        this.fRoot.addComponentListener(this);
        this.fTreeViewer.setInput((Object)this.fRoot);
        this.createContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.fTreeViewer);
        RSECorePlugin.getTheSystemRegistry();
    }

    public void setFocus() {
        this.fTreeViewer.getControl().setFocus();
    }

    @Override
    public void componentAdded(ITraceControlComponent parent, ITraceControlComponent component) {
        this.componentChanged(parent);
    }

    @Override
    public void componentRemoved(ITraceControlComponent parent, ITraceControlComponent component) {
        this.componentChanged(parent);
    }

    @Override
    public void componentChanged(final ITraceControlComponent component) {
        if (this.fTreeViewer.getTree().isDisposed()) {
            return;
        }
        UIJob myJob = new UIJob("Refresh"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (ControlView.this.fTreeViewer.getTree().isDisposed()) {
                    return Status.OK_STATUS;
                }
                ControlView.this.fTreeViewer.refresh((Object)component);
                ISelection sel = ControlView.this.fTreeViewer.getSelection();
                ControlView.this.fTreeViewer.setSelection(null);
                ControlView.this.fTreeViewer.setSelection(sel);
                ControlView.this.fTreeViewer.reveal((Object)component);
                return Status.OK_STATUS;
            }
        };
        myJob.setUser(false);
        myJob.schedule();
    }

    public void setSelection(ITraceControlComponent component) {
        ITraceControlComponent[] components = new ITraceControlComponent[]{component};
        this.setSelection(components);
    }

    public void setSelection(ITraceControlComponent[] components) {
        final StructuredSelection selection = new StructuredSelection((Object[])components);
        UIJob myJob = new UIJob("Select"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ControlView.this.fTreeViewer.setSelection((ISelection)selection);
                return Status.OK_STATUS;
            }
        };
        myJob.setUser(false);
        myJob.schedule();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.fTreeViewer.getTree());
        this.fTreeViewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.fTreeViewer);
    }
}

