/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.launch.configuration;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OpEvent;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OpUnitMask;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OprofileDaemonEvent;
import org.eclipse.linuxtools.internal.oprofile.launch.OprofileLaunchMessages;
import org.eclipse.linuxtools.internal.oprofile.launch.OprofileLaunchPlugin;

public class OprofileCounter {
    private static final String COUNTER_STRING = OprofileLaunchMessages.getString("oprofileCounter.counterString");
    private int number;
    private boolean _enabled;
    private OprofileDaemonEvent daemonEvent;
    private OpEvent[] eventList = null;

    public OprofileCounter(int nr) {
        this(nr, Oprofile.getEvents((int)nr));
    }

    public OprofileCounter(int nr, OpEvent[] events) {
        this.number = nr;
        this._enabled = false;
        this.eventList = events;
        this.daemonEvent = new OprofileDaemonEvent();
    }

    public static OprofileCounter[] getCounters(ILaunchConfiguration config) {
        OprofileCounter[] ctrs = new OprofileCounter[Oprofile.getNumberOfCounters()];
        int i = 0;
        while (i < ctrs.length) {
            ctrs[i] = new OprofileCounter(i);
            if (config != null) {
                ctrs[i].loadConfiguration(config);
            }
            ++i;
        }
        return ctrs;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public void setEvent(OpEvent event) {
        this.daemonEvent.setEvent(event);
    }

    public void setProfileKernel(boolean profileKernel) {
        this.daemonEvent.setProfileKernel(profileKernel);
    }

    public void setProfileUser(boolean profileUser) {
        this.daemonEvent.setProfileUser(profileUser);
    }

    public void setCount(int count) {
        this.daemonEvent.setResetCount(count);
    }

    public void saveConfiguration(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(OprofileLaunchPlugin.ATTR_COUNTER_ENABLED(this.number), this._enabled);
        if (this.daemonEvent.getEvent() != null) {
            config.setAttribute(OprofileLaunchPlugin.ATTR_COUNTER_EVENT(this.number), this.daemonEvent.getEvent().getText());
            config.setAttribute(OprofileLaunchPlugin.ATTR_COUNTER_UNIT_MASK(this.number), this.daemonEvent.getEvent().getUnitMask().getMaskValue());
        }
        config.setAttribute(OprofileLaunchPlugin.ATTR_COUNTER_PROFILE_KERNEL(this.number), this.daemonEvent.getProfileKernel());
        config.setAttribute(OprofileLaunchPlugin.ATTR_COUNTER_PROFILE_USER(this.number), this.daemonEvent.getProfileUser());
        config.setAttribute(OprofileLaunchPlugin.ATTR_COUNTER_COUNT(this.number), this.daemonEvent.getResetCount());
    }

    public void loadConfiguration(ILaunchConfiguration config) {
        try {
            this._enabled = config.getAttribute(OprofileLaunchPlugin.ATTR_COUNTER_ENABLED(this.number), false);
            String str = config.getAttribute(OprofileLaunchPlugin.ATTR_COUNTER_EVENT(this.number), "");
            this.daemonEvent.setEvent(this._eventFromString(str));
            if (this.daemonEvent.getEvent() == null) {
                return;
            }
            int maskValue = config.getAttribute(OprofileLaunchPlugin.ATTR_COUNTER_UNIT_MASK(this.number), -1);
            this.daemonEvent.getEvent().getUnitMask().setMaskValue(maskValue);
            this.daemonEvent.setProfileKernel(config.getAttribute(OprofileLaunchPlugin.ATTR_COUNTER_PROFILE_KERNEL(this.number), false));
            this.daemonEvent.setProfileUser(config.getAttribute(OprofileLaunchPlugin.ATTR_COUNTER_PROFILE_USER(this.number), false));
            this.daemonEvent.setResetCount(config.getAttribute(OprofileLaunchPlugin.ATTR_COUNTER_COUNT(this.number), 0));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public OpUnitMask getUnitMask() {
        OpEvent event = this.daemonEvent.getEvent();
        if (event != null) {
            return event.getUnitMask();
        }
        return null;
    }

    public String getText() {
        Object[] args = new Object[]{this.number};
        return MessageFormat.format(COUNTER_STRING, args);
    }

    public int getNumber() {
        return this.number;
    }

    public boolean getEnabled() {
        return this._enabled;
    }

    public OpEvent getEvent() {
        return this.daemonEvent.getEvent();
    }

    public boolean getProfileKernel() {
        return this.daemonEvent.getProfileKernel();
    }

    public boolean getProfileUser() {
        return this.daemonEvent.getProfileUser();
    }

    public int getCount() {
        return this.daemonEvent.getResetCount();
    }

    public OpEvent[] getValidEvents() {
        return this.eventList;
    }

    public OprofileDaemonEvent getDaemonEvent() {
        return this.daemonEvent;
    }

    private OpEvent _eventFromString(String str) {
        int i = 0;
        while (i < this.eventList.length) {
            if (this.eventList[i].getText().equals(str)) {
                return this.eventList[i];
            }
            ++i;
        }
        return null;
    }
}

