/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.linuxtools.internal.perf.BaseDataManipulator;
import org.eclipse.linuxtools.internal.perf.IPerfData;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public abstract class AbstractDataManipulator
extends BaseDataManipulator
implements IPerfData {
    private String text;
    private String title;
    private File workDir;
    private ILaunch launch;
    private List<Thread> threads;

    AbstractDataManipulator(String title, File workDir) {
        this.title = title;
        this.workDir = workDir;
        this.threads = new ArrayList<Thread>();
    }

    @Override
    public String getPerfData() {
        return this.text;
    }

    protected File getWorkDir() {
        return this.workDir;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setLaunch(ILaunch launch) {
        this.launch = launch;
    }

    public void performCommand(String[] cmd, int fd) {
        BufferedReader buffData = null;
        BufferedReader buffTemp = null;
        try {
            try {
                Process proc;
                if (this.workDir != null) {
                    Path path = new Path(this.workDir.getAbsolutePath());
                    IFileStore workDirStore = EFS.getLocalFileSystem().getStore((IPath)path);
                    proc = RuntimeProcessFactory.getFactory().exec(cmd, null, workDirStore, null);
                } else {
                    proc = RuntimeProcessFactory.getFactory().exec(cmd, null);
                }
                StringBuffer data = new StringBuffer();
                StringBuffer temp = new StringBuffer();
                switch (fd) {
                    case 2: {
                        buffData = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                        buffTemp = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        this.readStream(buffTemp, temp);
                        this.readStream(buffData, data);
                        break;
                    }
                    default: {
                        buffData = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        buffTemp = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                        this.readStream(buffData, data);
                        this.readStream(buffTemp, temp);
                    }
                }
                this.joinAll();
                this.text = data.toString();
                this.printToConsole(proc, temp.toString());
            }
            catch (IOException e) {
                this.text = "";
                try {
                    if (buffData != null) {
                        buffData.close();
                    }
                    if (buffTemp != null) {
                        buffTemp.close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (InterruptedException e) {
                this.text = "";
                try {
                    if (buffData != null) {
                        buffData.close();
                    }
                    if (buffTemp != null) {
                        buffTemp.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (buffData != null) {
                    buffData.close();
                }
                if (buffTemp != null) {
                    buffTemp.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void readStream(final BufferedReader buff, final StringBuffer strBuff) {
        Thread readThread = new Thread(new Runnable(){

            @Override
            public void run() {
                strBuff.append(AbstractDataManipulator.this.getBufferContents(buff));
            }
        });
        readThread.start();
        this.threads.add(readThread);
    }

    private void printToConsole(Process p, String s) {
        if (this.launch != null) {
            String configName = this.launch.getLaunchConfiguration().getName();
            DebugPlugin.newProcess((ILaunch)this.launch, (Process)p, (String)"");
            ConsolePlugin plugin = ConsolePlugin.getDefault();
            IConsoleManager conMan = plugin.getConsoleManager();
            IConsole[] existing = conMan.getConsoles();
            IOConsole binaryOutCons = null;
            IConsole[] iConsoleArray = existing;
            int n = existing.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole x = iConsoleArray[n2];
                if (x.getName().contains(configName) && x instanceof IOConsole) {
                    binaryOutCons = (IOConsole)x;
                }
                ++n2;
            }
            if (binaryOutCons != null) {
                IOConsoleOutputStream outputTo = binaryOutCons.newOutputStream();
                PrintStream print = new PrintStream((OutputStream)outputTo);
                print.println(s);
            }
        }
    }

    private void joinAll() throws InterruptedException {
        for (Thread thread : this.threads) {
            thread.join();
        }
    }

    public abstract void parse();
}

