/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;

public class BaseDataManipulator {
    public String getBufferContents(BufferedReader buffer) {
        if (buffer == null) {
            return "";
        }
        StringBuilder fileStr = new StringBuilder();
        try {
            String line;
            while ((line = buffer.readLine()) != null) {
                fileStr.append(line);
                fileStr.append("\n");
            }
        }
        catch (IOException e) {
            PerfPlugin.getDefault().openError(e, "");
        }
        return fileStr.toString();
    }

    public void copyFile(File src, File dest) {
        block7: {
            FileInputStream destInput = null;
            FileOutputStream srcOutput = null;
            try {
                int length;
                destInput = new FileInputStream(src);
                srcOutput = new FileOutputStream(dest);
                byte[] buffer = new byte[1024];
                while ((length = ((InputStream)destInput).read(buffer)) != -1) {
                    ((OutputStream)srcOutput).write(buffer, 0, length);
                }
            }
            catch (FileNotFoundException e) {
                PerfPlugin.getDefault().openError(e, "");
                this.closeResource(destInput);
                this.closeResource(srcOutput);
                break block7;
            }
            catch (IOException e) {
                try {
                    PerfPlugin.getDefault().openError(e, "");
                    this.closeResource(destInput);
                    this.closeResource(srcOutput);
                    break block7;
                }
                catch (Throwable throwable) {
                    this.closeResource(destInput);
                    this.closeResource(srcOutput);
                    throw throwable;
                }
            }
            this.closeResource(destInput);
            this.closeResource(srcOutput);
        }
    }

    public String fileToString(File file) {
        String result;
        block6: {
            if (file == null | !file.exists()) {
                return "";
            }
            BufferedReader fileReader = null;
            result = "";
            try {
                try {
                    fileReader = new BufferedReader(new FileReader(file));
                    result = this.getBufferContents(fileReader);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.closeResource(fileReader);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.closeResource(fileReader);
                throw throwable;
            }
            this.closeResource(fileReader);
        }
        return result;
    }

    public void closeResource(Closeable resrc) {
        if (resrc != null) {
            try {
                resrc.close();
            }
            catch (IOException e) {
                PerfPlugin.getDefault().openError(e, "");
            }
        }
    }
}

