/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.internal.perf.AbstractDataManipulator;
import org.eclipse.linuxtools.internal.perf.handlers.PerfSaveStatsHandler;

public class StatData
extends AbstractDataManipulator {
    private String prog;
    private String[] args;
    private int runCount;
    private String[] events;

    public StatData(String title, File workDir, String prog, String[] args, int runCount, String[] events) {
        super(title, workDir);
        this.prog = prog;
        this.args = args;
        this.runCount = runCount;
        this.events = events;
    }

    @Override
    public void parse() {
        String[] cmd = this.getCommand(this.prog, this.args);
        this.performCommand(cmd, 2);
    }

    protected String[] getCommand(String prog, String[] args) {
        ArrayList<String> ret = new ArrayList<String>(Arrays.asList("perf", "stat"));
        if (this.runCount > 1) {
            ret.add("-r");
            ret.add(String.valueOf(this.runCount));
        }
        if (this.events != null) {
            String[] stringArray = this.events;
            int n = this.events.length;
            int n2 = 0;
            while (n2 < n) {
                String event = stringArray[n2];
                ret.add("-e");
                ret.add(event);
                ++n2;
            }
        }
        ret.add(prog);
        ret.addAll(Arrays.asList(args));
        return ret.toArray(new String[0]);
    }

    protected String getProgram() {
        return this.prog;
    }

    protected String[] getArguments() {
        return this.args;
    }

    public void updateStatData() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("perf");
        stringBuilder.append("%s.");
        stringBuilder.append(PerfSaveStatsHandler.DATA_EXT);
        String statNameFormat = stringBuilder.toString();
        Path workingDir = new Path(this.getWorkDir().getAbsolutePath());
        String curStatName = String.format(statNameFormat, "");
        IPath curStatPath = workingDir.append(curStatName);
        File curStatFile = new File(curStatPath.toOSString());
        if (curStatFile.exists()) {
            String oldStatName = String.format(statNameFormat, ".old");
            IPath oldStatPath = workingDir.append(oldStatName);
            File oldStatFile = oldStatPath.toFile();
            if (oldStatFile.exists()) {
                oldStatFile.delete();
            }
            curStatFile.renameTo(oldStatFile);
        }
        PerfSaveStatsHandler saveStats = new PerfSaveStatsHandler();
        saveStats.saveData("perf");
    }
}

