/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.handlers;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.perf.handlers.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractComparisonHandler
implements IHandler {
    private static ArrayList<IFile> selectedFiles = new ArrayList();
    private ISelection prevSelection;
    private ISelectionListener workbenchListener;

    public Object execute(ExecutionEvent event) {
        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.MsgSelectionDiff, (String)Messages.MsgSelectFiles);
        this.workbenchListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart sourcepart, ISelection selection) {
                AbstractComparisonHandler.this.handleSelection(sourcepart, selection);
            }
        };
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        workbenchWindow.getSelectionService().addSelectionListener(this.workbenchListener);
        return null;
    }

    public boolean isEnabled() {
        return this.workbenchListener == null;
    }

    public boolean isHandled() {
        return this.isEnabled();
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public static ArrayList<IFile> getSelectedFiles() {
        return selectedFiles;
    }

    private IFile getFile(ISelection selection) throws ClassCastException {
        return (IFile)((IStructuredSelection)selection).getFirstElement();
    }

    protected abstract boolean isValidFile(IFile var1);

    private void handleSelection(IWorkbenchPart sourcepart, ISelection selection) {
        if (!selection.equals(this.prevSelection)) {
            try {
                IFile file = this.getFile(selection);
                if (this.isValidFile(file) && selectedFiles.add(file) && selectedFiles.size() == 2) {
                    IFile newData;
                    IFile oldData = selectedFiles.get(0);
                    if (this.confirmSelections(oldData, newData = selectedFiles.get(1))) {
                        this.handleComparison(oldData, newData);
                    }
                    this.clearSelections();
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.prevSelection = selection;
    }

    private boolean confirmSelections(IFile oldFile, IFile newFile) {
        Object[] confirmMsgArgs = new String[]{oldFile.getName(), newFile.getName()};
        String confirmMsg = MessageFormat.format(Messages.MsgConfirm_msg, confirmMsgArgs);
        boolean confirm = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.MsgConfirm_title, (String)confirmMsg);
        return confirm;
    }

    protected abstract void handleComparison(IFile var1, IFile var2);

    private void clearSelections() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().removeSelectionListener(this.workbenchListener);
        this.workbenchListener = null;
        selectedFiles.clear();
    }
}

