/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.handlers;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.perf.BaseDataManipulator;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.handlers.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractSaveDataHandler
extends BaseDataManipulator
implements IHandler {
    public Object execute(ExecutionEvent event) {
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.PerfSaveSession_title, Messages.PerfSaveSession_msg, "", new IInputValidator(){

            public String isValid(String newText) {
                if ("".equals(newText)) {
                    return Messages.PerfSaveSession_invalid_filename_msg;
                }
                return null;
            }
        });
        if (dialog.open() == 0) {
            this.saveData(dialog.getValue());
        }
        return null;
    }

    public boolean isEnabled() {
        IPath curWorkingDirectory = this.getWorkingDir();
        return curWorkingDirectory != null && !curWorkingDirectory.isEmpty() && this.verifyData();
    }

    protected IPath getWorkingDir() {
        return PerfPlugin.getDefault().getWorkingDir();
    }

    public IPath getNewDataLocation(String filename, String extension) {
        IPath newFilename = this.getWorkingDir().append(filename);
        return newFilename.addFileExtension(extension);
    }

    public boolean canSave(File file) {
        if (file.exists()) {
            String msg = MessageFormat.format(Messages.PerfSaveSession_file_exists_msg, file.getName());
            return MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PerfSaveSession_file_exists_title, (String)msg);
        }
        return true;
    }

    public void openErroDialog(String title, String pattern, String arg) {
        String errorMsg = MessageFormat.format(pattern, arg);
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)errorMsg);
    }

    public abstract File saveData(String var1);

    public abstract boolean verifyData();

    public boolean isHandled() {
        return this.isEnabled();
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }
}

