/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.handlers;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.handlers.AbstractSaveDataHandler;
import org.eclipse.linuxtools.internal.perf.handlers.Messages;
import org.eclipse.linuxtools.internal.perf.ui.PerfProfileView;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class PerfSaveSessionHandler
extends AbstractSaveDataHandler {
    public static final String DATA_EXT = "data";

    @Override
    public File saveData(String filename) {
        IPath newDataLoc = this.getNewDataLocation(filename, DATA_EXT);
        IPath defaultDataLoc = PerfPlugin.getDefault().getPerfProfileData();
        File newDataFile = new File(newDataLoc.toOSString());
        File defaultDataFile = defaultDataLoc.toFile();
        if (this.canSave(newDataFile)) {
            try {
                newDataFile.createNewFile();
                this.copyFile(defaultDataFile, newDataFile);
                PerfPlugin.getDefault().setPerfProfileData(newDataLoc);
                try {
                    PerfProfileView view = (PerfProfileView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.perf.ui.ProfileView");
                    view.setContentDescription(newDataLoc.toOSString());
                }
                catch (PartInitException view) {
                    // empty catch block
                }
                return newDataFile;
            }
            catch (IOException e) {
                this.openErroDialog(Messages.PerfSaveSession_failure_title, Messages.PerfSaveSession_failure_msg, newDataLoc.lastSegment());
            }
        }
        return null;
    }

    @Override
    public boolean verifyData() {
        IPath defaultDataLoc = PerfPlugin.getDefault().getPerfProfileData();
        return defaultDataLoc != null && !defaultDataLoc.isEmpty();
    }
}

