/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.handlers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.internal.perf.IPerfData;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.handlers.AbstractSaveDataHandler;
import org.eclipse.linuxtools.internal.perf.handlers.Messages;

public class PerfSaveStatsHandler
extends AbstractSaveDataHandler {
    public static String DATA_EXT = "stat";

    @Override
    public File saveData(String filename) {
        IPath newDataLoc = this.getNewDataLocation(filename, DATA_EXT);
        IPerfData statData = PerfPlugin.getDefault().getStatData();
        File statsData = new File(newDataLoc.toOSString());
        if (this.canSave(statsData)) {
            BufferedWriter bw = null;
            try {
                statsData.createNewFile();
                FileWriter fw = new FileWriter(statsData.getAbsoluteFile());
                bw = new BufferedWriter(fw);
                bw.write(statData.getPerfData());
                File file = statsData;
                this.closeResource(bw);
                return file;
            }
            catch (IOException e) {
                this.openErroDialog(Messages.PerfSaveStat_error_title, Messages.PerfSaveStat_error_msg, newDataLoc.lastSegment());
            }
            finally {
                this.closeResource(bw);
            }
        }
        return null;
    }

    @Override
    public boolean verifyData() {
        IPerfData statData = PerfPlugin.getDefault().getStatData();
        return statData != null && statData.getPerfData() != null;
    }
}

