/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.handlers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.internal.perf.IPerfData;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.handlers.Messages;
import org.eclipse.linuxtools.internal.perf.ui.StatView;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorLauncher;

public class PerfStatDataOpenHandler
implements IEditorLauncher {
    private static final String TITLE_EXCERPT = "Performance counter stats for";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void open(IPath file) {
        File statFile = file.toFile();
        BufferedReader fileReader = null;
        try {
            try {
                String line;
                fileReader = new BufferedReader(new FileReader(statFile));
                final StringBuilder contents = new StringBuilder();
                final StringBuilder title = new StringBuilder();
                while ((line = fileReader.readLine()) != null) {
                    if (title.length() == 0 && line.contains(TITLE_EXCERPT)) {
                        title.append(line);
                    }
                    contents.append(line);
                    contents.append("\n");
                }
                if (title.length() == 0) {
                    title.append(NLS.bind((String)Messages.PerfEditorLauncher_stat_title, (Object)statFile.getName()));
                }
                PerfPlugin.getDefault().setStatData(new IPerfData(){

                    @Override
                    public String getTitle() {
                        return title.toString();
                    }

                    @Override
                    public String getPerfData() {
                        return contents.toString();
                    }
                });
                StatView.refreshView();
                return;
            }
            catch (FileNotFoundException e) {
                PerfPlugin.getDefault().openError(e, NLS.bind((String)Messages.PerfEditorLauncher_file_dne_error, (Object)statFile.getName()));
                if (fileReader == null) return;
                try {
                    fileReader.close();
                    return;
                }
                catch (IOException e2) {
                    PerfPlugin.getDefault().openError(e2, "");
                }
                return;
            }
            catch (IOException e) {
                PerfPlugin.getDefault().openError(e, NLS.bind((String)Messages.PerfEditorLauncher_file_read_error, (Object)statFile.getName()));
                if (fileReader == null) return;
                try {
                    fileReader.close();
                    return;
                }
                catch (IOException e3) {
                    PerfPlugin.getDefault().openError(e3, "");
                }
                return;
            }
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException e) {
                    PerfPlugin.getDefault().openError(e, "");
                }
            }
        }
    }
}

