/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.linuxtools.internal.perf.IPerfData;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.StatComparisonData;
import org.eclipse.linuxtools.internal.perf.handlers.Messages;
import org.eclipse.linuxtools.internal.perf.ui.StatComparisonView;
import org.eclipse.swt.widgets.Event;

public class PerfStatDiffMenuAction
extends Action {
    private Type dataType;
    private String secondaryID;

    public PerfStatDiffMenuAction(Type type, String sID) {
        this.dataType = type;
        this.secondaryID = sID;
        switch (this.dataType) {
            case PERF_OLD: {
                this.setToolTipText(Messages.PerfStatDiffMenuAction_old_tooltip);
                this.setImageDescriptor(PerfPlugin.getImageDescriptor("icons/backward_nav.gif"));
                break;
            }
            case PERF_NEW: {
                this.setToolTipText(Messages.PerfStatDiffMenuAction_new_tooltip);
                this.setImageDescriptor(PerfPlugin.getImageDescriptor("icons/forward_nav.gif"));
                break;
            }
            case PERF_DIFF: {
                this.setToolTipText(Messages.PerfStatDiffMenuAction_stats_tooltip);
                this.setImageDescriptor(PerfPlugin.getImageDescriptor("icons/twowaycompare_co.gif"));
            }
        }
    }

    public void runWithEvent(Event event) {
        StatComparisonData data;
        StatComparisonView view = (StatComparisonView)StatComparisonView.getView(this.secondaryID);
        StatComparisonData statComparisonData = data = view == null ? null : (StatComparisonData)view.getDiffData();
        if (view != null && data != null) {
            IPerfData perfData = null;
            boolean style = false;
            switch (this.dataType) {
                case PERF_OLD: {
                    perfData = new PerfCachedData(data.getOldDataID(), data.getOldDataPath());
                    break;
                }
                case PERF_NEW: {
                    perfData = new PerfCachedData(data.getNewDataID(), data.getNewDataPath());
                    break;
                }
                case PERF_DIFF: {
                    perfData = data;
                    style = true;
                }
            }
            view.updateData(perfData, style);
        }
    }

    public class PerfCachedData
    implements IPerfData {
        private String cachedDataID;
        private String title;

        public PerfCachedData(String dataID, String dataTitle) {
            this.cachedDataID = dataID;
            this.title = dataTitle;
        }

        @Override
        public String getPerfData() {
            return PerfPlugin.getDefault().getCachedData(this.cachedDataID);
        }

        @Override
        public String getTitle() {
            return this.title;
        }
    }

    public static enum Type {
        PERF_OLD,
        PERF_NEW,
        PERF_DIFF;

    }
}

