/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.linuxtools.internal.perf.model.PMDso;
import org.eclipse.linuxtools.internal.perf.model.PMFile;
import org.eclipse.linuxtools.internal.perf.model.PMLineRef;
import org.eclipse.linuxtools.internal.perf.model.PMSymbol;
import org.eclipse.linuxtools.profiling.ui.ProfileUIUtils;
import org.eclipse.ui.PartInitException;

public class PerfDoubleClickAction
extends Action {
    private TreeViewer viewer;

    public PerfDoubleClickAction(TreeViewer v) {
        this.viewer = v;
    }

    public void run() {
        ISelection selection = this.viewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        try {
            if (obj instanceof PMLineRef) {
                PMLineRef line = (PMLineRef)obj;
                PMFile file = (PMFile)((PMSymbol)line.getParent()).getParent();
                ProfileUIUtils.openEditorAndSelect((String)file.getPath(), (int)Integer.parseInt(line.getName()));
            } else if (obj instanceof PMFile) {
                PMFile file = (PMFile)obj;
                ProfileUIUtils.openEditorAndSelect((String)file.getName(), (int)1);
            } else if (obj instanceof PMSymbol) {
                PMSymbol sym = (PMSymbol)obj;
                PMFile file = (PMFile)sym.getParent();
                PMDso dso = (PMDso)file.getParent();
                if (file.getName().equals("Unfiled Symbols")) {
                    return;
                }
                String binaryPath = dso.getPath();
                ICProject project = ProfileUIUtils.findCProjectWithAbsolutePath((String)binaryPath);
                HashMap map = ProfileUIUtils.findFunctionsInProject((ICProject)project, (String)sym.getFunctionName(), (int)-1, (String)file.getPath(), (boolean)true);
                boolean bFound = false;
                for (Map.Entry entry : map.entrySet()) {
                    ProfileUIUtils.openEditorAndSelect((String)((String)entry.getKey()), (int)((int[])entry.getValue())[0], (int)((int[])entry.getValue())[1]);
                    bFound = true;
                }
                if (!bFound) {
                    ProfileUIUtils.openEditorAndSelect((String)file.getPath(), (int)1);
                }
            }
        }
        catch (PartInitException partInitException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (BadLocationException badLocationException) {
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }
}

